﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/system/hid_UniquePad.h>

#include "hid_UniquePadResourceManager.h"

namespace nn { namespace hid { namespace detail {

//!< Npad デバイス割り当ての解決を担うマネージャを扱うクラスです。
class NpadUniquePadConverter final
{

private:
    //!< UniquePad リソースマネージャー
    UniquePadResourceManager* m_pUniquePadResourceManager;

public:
    //!< UniquePad リソースマネージャーを設定します。
    void SetUniquePadResourceManager(UniquePadResourceManager* pManager) NN_NOEXCEPT;

    //!< Npad に割り当てられた UniquePad を取得します。
    int GetUniquePads(system::UniquePadId* pOutValues, int count, NpadIdType& id) NN_NOEXCEPT;

    //!< Npad に割り当てられた UniquePad をデバイスタイプを指定して取得します。
    bool GetUniquePads(system::UniquePadId* pOutValue, NpadIdType& id, system::NpadDeviceTypeSet& deviceType) NN_NOEXCEPT;

private:
    //!< UniquePad の Id を取得する
    int GetUniquePadIds(system::UniquePadId* pOutValues, int count) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
