﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include "hid_NpadAppletPolicyManager.h"
#include "hid_PalmaResourceManager.h"

namespace nn { namespace hid { namespace detail {

//!< Palma の状態の制御を担うクラスです。
class NpadPalmaScanController final
{
    NN_DISALLOW_COPY(NpadPalmaScanController);
    NN_DISALLOW_MOVE(NpadPalmaScanController);

private:
    //!< Palma の管理を行うリソースマネージャー
    NpadAppletPolicyManager* m_pAppletPolicyManager;

    //!< Palma の管理を行うリソースマネージャー
    PalmaResourceManager* m_pPalmaResourceManager;

public:
    NpadPalmaScanController() NN_NOEXCEPT;

    ~NpadPalmaScanController() NN_NOEXCEPT;

    //!< NpadAppletPolicyManager を設定します。
    void SetNpadAppletPolicyManager(NpadAppletPolicyManager* pManager) NN_NOEXCEPT;

    //!< PalmaResourceManager を設定します。
    void SetPalmaResourceManager(PalmaResourceManager* pManager) NN_NOEXCEPT;

    //!< Scan の状態を更新します。
    void UpdateScanState() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
