﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_ResultPrivate.h>

#include "hid_HidSystemServer.h"


namespace nn { namespace hid { namespace detail {

::nn::Result BindNfcDeviceUpdateEvent(::nn::os::SystemEventType* pEvent,
                              ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    CreateHidSystemServerProxy(&pProxy);

    auto handle = ::nn::sf::NativeHandle();
    NN_RESULT_DO(pProxy->AcquireNfcDeviceUpdateEventHandle(&handle));

    ::nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                                handle.GetOsHandle(),
                                                handle.IsManaged(),
                                                clearMode);

    // ハンドルの管理権を放棄
    handle.Detach();

    NN_RESULT_SUCCESS;
}

::nn::Result GetNpadsWithNfc(int* pOutCount, NpadIdType* pOutValue, int length) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidSystemServer> pProxy;
    NN_RESULT_DO(CreateHidSystemServerProxy(&pProxy));
    auto outGotCount = int64_t();
    NN_RESULT_DO(pProxy->GetNpadsWithNfc(::nn::sf::Out<int64_t>(&outGotCount), ::nn::sf::OutArray<NpadIdType>(pOutValue, length)));
    *pOutCount = static_cast<int>(outGotCount);
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail

