﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_Mouse.h>

#include "hid_Rectangle.h"

namespace nn { namespace hid { namespace detail {

namespace {

//!< Mouse の座標域
const Rectangle MouseRectangle = {
    0,      // x
    0,      // y
    1280,   // width
    720     // height
};

//!< カーソル位置の縮尺を変域に合わせます。
inline MouseState ScaleMousePosition(
    const MouseState& state, const Rectangle& rect) NN_NOEXCEPT
{
    MouseState value = state;

    if (0 < rect.width)
    {
        value.x = value.x * MouseRectangle.width / rect.width;
    }

    if (0 < rect.height)
    {
        value.y = value.y * MouseRectangle.height / rect.height;
    }

    return value;
}

} // namespace

}}} // namespace nn::hid::detail
