﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/system/hid_Keyboard.h>

#include "hid_ActivationCount.h"
#include "hid_IKeyboardDriver.h"
#include "hid_WindowsKeyboard-os.win.h"

namespace nn { namespace hid { namespace detail {

class KeyboardDriver final : public IKeyboardDriver
{
    NN_DISALLOW_COPY(KeyboardDriver);
    NN_DISALLOW_MOVE(KeyboardDriver);

private:
    //!< このインスタンスからドライバがアクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< Windows のキーボード
    WindowsKeyboard m_WindowsKeyboard;

public:
    KeyboardDriver() NN_NOEXCEPT;

    virtual ~KeyboardDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(KeyboardState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result SendLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEventSet value
        ) NN_NOEXCEPT NN_OVERRIDE;
};

}}} // namespace nn::hid::detail
