﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/system/hid_Keyboard.h>
#include <nn/util/util_BitPack.h>

#include "hid_ActivationCount.h"
#include "hid_IKeyboardDriver.h"

namespace nn { namespace hid { namespace detail {

class KeyboardDriver final : public IKeyboardDriver
{
    NN_DISALLOW_COPY(KeyboardDriver);
    NN_DISALLOW_MOVE(KeyboardDriver);

public:
    //!< ポートの数
    static const size_t PortCount = 8;

private:
    //!< このインスタンスからドライバがアクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< 修飾キーの押下状態
    ::nn::hid::KeyboardModifierSet m_Modifiers;

    //!< アタッチ状態にあるポートの数
    ::std::atomic<int> m_Count;

    //!< LED の点灯状態
    ::std::atomic<uint8_t> m_Leds;

    //!< レポート
    ::std::atomic<uint64_t> m_Reports[PortCount];

public:
    KeyboardDriver() NN_NOEXCEPT;

    virtual ~KeyboardDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(KeyboardState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result SendLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEventSet value
        ) NN_NOEXCEPT NN_OVERRIDE;

    //!< アタッチ処理を行います。
    void Attach(size_t port);

    //!< デタッチ処理を行います。
    void Detach(size_t port);

    //!< LED の点灯状態を取得します。
    uint8_t GetLedPattern() const NN_NOEXCEPT;

    //!< レポートを設定します。
    void SetReport(size_t port, uint64_t reports) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
