﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/hid/hid_JoyXpad.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/TargetConfigs/build_Base.h>

#include "hid_RingLifo.h"

namespace nn { namespace hid { namespace detail {

class JoyXpadLifo final : public RingLifo<JoyXpadState, XpadStateCountMax>
{
public:
    JoyXpadLifo() NN_NOEXCEPT { /* 何もしない */ }
};

class JoyXpadLifoPair final
{
    NN_DISALLOW_COPY(JoyXpadLifoPair);
    NN_DISALLOW_MOVE(JoyXpadLifoPair);

private:
    JoyXpadLifo m_LeftLifo;
    JoyXpadLifo m_RightLifo;

public:
    JoyXpadLifoPair(): m_LeftLifo(), m_RightLifo() {}
    ~JoyXpadLifoPair() {}

    JoyXpadLifo& GetLeftLifo() { return m_LeftLifo; }
    JoyXpadLifo& GetRightLifo() { return m_RightLifo; }
};

#ifdef NN_BUILD_CONFIG_TOOLCHAIN_CLANG
NN_STATIC_ASSERT(::std::is_standard_layout<JoyXpadLifo>::value);
#endif

class JoyXpadSixAxisSensorLifo final : public RingLifo<::nn::hid::SixAxisSensorState, SixAxisSensorStateCountMax>
{
public:
    JoyXpadSixAxisSensorLifo() NN_NOEXCEPT { /* 何もしない */ }
};

#ifdef NN_BUILD_CONFIG_TOOLCHAIN_CLANG
NN_STATIC_ASSERT(::std::is_standard_layout<JoyXpadSixAxisSensorLifo>::value);
#endif

class JoyXpadSixAxisSensorLifoPair final
{
    NN_DISALLOW_COPY(JoyXpadSixAxisSensorLifoPair);
    NN_DISALLOW_MOVE(JoyXpadSixAxisSensorLifoPair);

private:
    JoyXpadSixAxisSensorLifo m_LeftLifo;
    JoyXpadSixAxisSensorLifo m_RightLifo;

public:
    JoyXpadSixAxisSensorLifoPair(): m_LeftLifo(), m_RightLifo() {}
    ~JoyXpadSixAxisSensorLifoPair() {}

    JoyXpadSixAxisSensorLifo& GetLeftLifo() { return m_LeftLifo; }
    JoyXpadSixAxisSensorLifo& GetRightLifo() { return m_RightLifo; }
};

}}} // namespace nn::hid::detail
