﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace hid { namespace detail {


struct UsbPadState
{
    int64_t samplingNumber;
    ::nn::util::BitFlagSet<24> buttons; //!< ボタンの状態です。
    uint16_t analogLeftX;
    uint16_t analogLeftY;
    uint16_t analogRightX;
    uint16_t analogRightY;
    //    ::nn::util::Float3 acc;
    //    ::nn::util::Float3 gyro;

};

class IUsbPadDriver
{
public:
    virtual ~IUsbPadDriver() NN_NOEXCEPT { /* 何もしない */ }

    virtual ::nn::Result Activate() NN_NOEXCEPT = 0;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT = 0;

    virtual void GetState(UsbPadState* outValue) NN_NOEXCEPT = 0;
};

}}} // namespace nn::hid::detail
