﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/debug/hid_HomeButton.h>
#include <nn/hid/system/hid_HomeButton.h>
#include <nn/os/os_SystemEventTypes.h>

namespace nn { namespace hid { namespace detail {

::nn::Result BindHomeButtonEvent(::nn::os::SystemEventType* pEvent,
                                 ::nn::os::EventClearMode clearMode
                                 ) NN_NOEXCEPT;

::nn::Result InitializeHomeButton() NN_NOEXCEPT;

::nn::Result FinalizeHomeButton() NN_NOEXCEPT;

::nn::Result GetHomeButtonStates(int* pOutCount,
                                 ::nn::hid::system::HomeButtonState outStates[],
                                 int count) NN_NOEXCEPT;

::nn::Result SetHomeButtonAutoPilotState(
    const ::nn::hid::debug::HomeButtonAutoPilotState& value) NN_NOEXCEPT;

::nn::Result UnsetHomeButtonAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::detail
