﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_ExternalBus.h>

namespace nn { namespace hid { namespace detail {

nn::Result IsExternalBusDeviceConnected(bool* pOutIsConnected, const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result InitializeExternalBus(const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result FinalizeExternalBus(const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result EnableExternalBusDevice(const ExternalBusHandle& handle, bool isEnabled, uint64_t version) NN_NOEXCEPT;
nn::Result GetExternalBusDeviceInfo(ExternalBusDeviceInfo* pOutInfo, const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result SendCommandAsyncToExternalBusDevice(const uint8_t* pInCommand, size_t inCommandSize, const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result GetSendCommandAsynceResultFromExternalBusDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize, const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result BindEventForExternalBusDeviceSendCommandAsycResult(nn::sf::Out<nn::sf::NativeHandle> receiveEventHandle, const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result EnablePollingReceiveModeForAttachmentDevice(const uint8_t* pInCommand, size_t inCommandSize, const ExternalBusHandle& handle, ExternalBusJoyPollingMode mode) NN_NOEXCEPT;
nn::Result DisablePollingReceiveModeForAttachmentDevice(const ExternalBusHandle& handle) NN_NOEXCEPT;
nn::Result GetPollingDataForAttachmentDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize, const ExternalBusHandle& handle) NN_NOEXCEPT;
}}} // namespace nn::hid::detail
