﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ConsoleSixAxisSensor の加工計算クラスの宣言
 */

#pragma once

#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>
#include <nn/util/util_MathTypes.h>

#include "hid_SixAxisSensorAppletSetting.h"
#include "hid_RingLifo.h"
#include "hid_SixAxisSensorLifo.h"
#include "hid_SixAxisSensorProcessor.h"

namespace nn { namespace hid { namespace detail {

//!< 本体 6軸センサーの処理を担うクラス
class ConsoleSixAxisSensorProcessor final
{
    NN_DISALLOW_COPY(ConsoleSixAxisSensorProcessor);
    NN_DISALLOW_MOVE(ConsoleSixAxisSensorProcessor);

private:

    //!< KPAD 互換の 6 軸センサーの加工処理クラス
    SixAxisSensorProcessor m_SixAxisSensorProcessor;

    //!< キャリブレーション値
    tmp::ConsoleSixAxisSensorCalibrationValues m_CalibrationValues;

    //!< 前回サンプリングした SixAxisSensorCountState
    nn::hid::tmp::SixAxisSensorCountState m_LastSixAxisSensorCountState;

public:
    ConsoleSixAxisSensorProcessor()  NN_NOEXCEPT;
    ~ConsoleSixAxisSensorProcessor() NN_NOEXCEPT {};

    //!< 6軸センサーの加工処理クラスの内部ステートをクリアします。
    void Reset() NN_NOEXCEPT;

    //!< 6軸センサーのパラメータを設定します。
    void SetSixAxisSensorSetting(const SixAxisSensorSetting* const pSetting) NN_NOEXCEPT;

    //!< SixAxisSensorCountState を注入して内部ステートを更新します。
    void Sampling(nn::hid::tmp::SixAxisSensorCountState& state) NN_NOEXCEPT;

    //!< SixAxisSensor の入力状態を過去に遡って読み出します。
    int  GetSixAxisSensorStates(SixAxisSensorState* outStates, int count ) const NN_NOEXCEPT;

    //!< キャリブレーション値を設定します
    void SetCalibrationValues(const tmp::ConsoleSixAxisSensorCalibrationValues& values) NN_NOEXCEPT;

    //!< SixAxisSensorProcessor を返します。
    const SixAxisSensorProcessor& GetSixAxisSensorProcessor() const NN_NOEXCEPT;

    //!< 削除予定: 開発用途でキャリブレーション値を取得します
    void GetCalibrationValues(tmp::ConsoleSixAxisSensorCalibrationValues* pOutValues) const NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
