﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/debug/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>

namespace nn { namespace hid { namespace detail {

::nn::Result InitializeConsoleSixAxisSensor() NN_NOEXCEPT;

::nn::Result StartSixAxisSensor(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

::nn::Result StopSixAxisSensor(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorCountStates(int* pOutCount,
                                                tmp::SixAxisSensorCountState outValues[],
                                                int count,
                                                ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorCalibrationValues(tmp::ConsoleSixAxisSensorCalibrationValues* pOutCalibrationValues,
                                                      ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorCountStates(int* pOutCount,
                                                debug::ConsoleSixAxisSensorCountState* pOutStates,
                                                int count) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorSamplingFrequency(int64_t* pOutValue) NN_NOEXCEPT;

::nn::Result FinalizeConsoleSixAxisSensor() NN_NOEXCEPT;

::nn::Result InitializeSevenSixAxisSensor(void* workBuffer, size_t workBufferSize) NN_NOEXCEPT;

::nn::Result FinalizeSevenSixAxisSensor() NN_NOEXCEPT;

::nn::Result StartSevenSixAxisSensor() NN_NOEXCEPT;

::nn::Result StopSevenSixAxisSensor() NN_NOEXCEPT;

::nn::Result GetSevenSixAxisSensorStates(int* pOutCount,
                                         SevenSixAxisSensorState outValues[],
                                         int count) NN_NOEXCEPT;

::nn::Result IsSevenSixAxisSensorAtRest(bool* pOutIsAtRest) NN_NOEXCEPT;

::nn::Result GetSensorFusionError(float* pOutSensorFusionError) NN_NOEXCEPT;

::nn::Result GetGyroBias(::nn::util::Float3* pOutGyroBias) NN_NOEXCEPT;

::nn::Result SetSevenSixAxisSensorFusionStrength(float strength) NN_NOEXCEPT;

::nn::Result GetSevenSixAxisSensorFusionStrength(float* pOutStrength) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
