﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/util/util_BitPack.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_ConsoleSixAxisSensorHandle.h"

namespace nn { namespace hid { namespace detail {

ConsoleSixAxisSensorHandle MakeConsoleSixAxisSensorHandle(uint8_t typeValue,
                                                          int index) NN_NOEXCEPT
{
    auto bitPack = ::nn::util::BitPack32();
    bitPack.Set<ConsoleSixAxisSensorHandleField::ConsoleSixAxisSensorTypeValue>(typeValue);
    bitPack.Set<ConsoleSixAxisSensorHandleField::ConsoleSixAxisSensorIndex>(static_cast<int8_t>(index));

    ConsoleSixAxisSensorHandle handle = { static_cast<int32_t>(bitPack.storage) };
    return handle;
}

uint8_t GetConsoleSixAxisSensorTypeValue(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT
{
    ::nn::util::BitPack32 bitPack = { static_cast<unsigned int>(handle._storage) };
    return bitPack.Get<ConsoleSixAxisSensorHandleField::ConsoleSixAxisSensorTypeValue>();
}

::nn::Result GetConsoleSixAxisSensorHandle(ConsoleSixAxisSensorHandle* pOutHandle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutHandle);

    *pOutHandle = detail::MakeConsoleSixAxisSensorHandle(ConsoleSixAxisSensorTypeValue::ConsoleSixAxisSensorTypeValue_Vr,
                                                         0);
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
