﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/os/os_TransferMemory.h>

#include "hid_SixAxisSensorAppletSetting.h"

namespace nn { namespace hid { namespace detail {

//!< Filter の設定値
struct FilterSetting
{
    float sensorFusionStrength; //!< 加速度センサーによる姿勢補正の強度

    void Reset() NN_NOEXCEPT;
};

//!< 6軸センサーの設定値
struct ConsoleSixAxisSensorSetting
{
    bool isSamplingEnabled;       //!< サンプリングが有効かどうか
    FilterSetting filterSetting;  //!< Filter の設定値

    void EnableSampling(bool enable) NN_NOEXCEPT;
    bool IsSamplingEnabled() const NN_NOEXCEPT;

    void SetSevenSixAxisSensorFusionStrength(float strength) NN_NOEXCEPT;
    float GetSevenSixAxisSensorFusionStrength() const NN_NOEXCEPT;

    FilterSetting GetFilterSetting() const NN_NOEXCEPT;
    void Reset(bool global) NN_NOEXCEPT;
};

//!< TransferMemory 関連の設定値
struct ConsoleSixAxisSensorTansferMemoryStatus
{
    ::nn::os::NativeHandle osHandle;
    bool isManaged;
    ::nn::os::TransferMemoryType transferMemoryType;
    void* address;
    size_t size;

    bool IsInitialized() const NN_NOEXCEPT
    {
        return address != nullptr;
    }

    void Reset() NN_NOEXCEPT
    {
        address = nullptr;
    }
};

//!< アプリごとに持つ Seven 向け 6軸センサーの設定値
struct ConsoleSixAxisSensorAppletSetting
{
    ConsoleSixAxisSensorSetting console;
    ConsoleSixAxisSensorTansferMemoryStatus workBuffer;
    ConsoleSixAxisSensorTansferMemoryStatus stateBuffer;

    void ResetConsoleSixAxisSensorSetting(bool global) NN_NOEXCEPT;

    ConsoleSixAxisSensorSetting* GetConsoleSixAxisSensorSetting(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
