﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_NpadId.h"
#include "hid_ConsoleSixAxisSensorAppletSetting.h"
#include "hid_SixAxisSensorHandle.h"

namespace nn { namespace hid { namespace detail {

void FilterSetting::Reset() NN_NOEXCEPT
{
    sensorFusionStrength = 1.f;
}

void ConsoleSixAxisSensorSetting::EnableSampling(bool enable) NN_NOEXCEPT
{
    isSamplingEnabled = enable;
}

bool ConsoleSixAxisSensorSetting::IsSamplingEnabled() const NN_NOEXCEPT
{
    return isSamplingEnabled;
}

void ConsoleSixAxisSensorSetting::SetSevenSixAxisSensorFusionStrength(float strength) NN_NOEXCEPT
{
    filterSetting.sensorFusionStrength = strength;
}

float ConsoleSixAxisSensorSetting::GetSevenSixAxisSensorFusionStrength() const NN_NOEXCEPT
{
    return filterSetting.sensorFusionStrength;
}

FilterSetting ConsoleSixAxisSensorSetting::GetFilterSetting() const NN_NOEXCEPT
{
    return filterSetting;
}

void ConsoleSixAxisSensorSetting::Reset(bool global) NN_NOEXCEPT
{
    NN_UNUSED(global);

    EnableSampling(false);
    filterSetting.Reset();
}

void ConsoleSixAxisSensorAppletSetting::ResetConsoleSixAxisSensorSetting(bool global) NN_NOEXCEPT
{
    workBuffer.Reset();
    stateBuffer.Reset();

    console.Reset(global);
}

ConsoleSixAxisSensorSetting* ConsoleSixAxisSensorAppletSetting::GetConsoleSixAxisSensorSetting(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT
{
    NN_UNUSED(handle);
    return &console;
}

}}} // namespace nn::hid::detail
