﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "hid_AttachmentDetector.h"
#include "hid_SixAxisSensorMathUtility.h"

namespace nn { namespace hid { namespace detail {

AttachmentDetector::AttachmentDetector() NN_NOEXCEPT
    : m_Probability(0.0f)
{
    // 何もしない
}

void AttachmentDetector::UpdateProbability(const nn::hid::SixAxisSensorState& left,
                                           const nn::hid::SixAxisSensorState& right) NN_NOEXCEPT
{
    // TODO: 検出精度・速度の改善
    float dotProduct;
    InnerProduct(&dotProduct, left.angularVelocity, right.angularVelocity);

    nn::util::Float3 deltaVector;
    for(int i = 0; i < 3; i++)
    {
        deltaVector.v[i] = left.angularVelocity.v[i] - right.angularVelocity.v[i];
    }
    float deltaNorm2;
    InnerProduct(&deltaNorm2, deltaVector, deltaVector);

    float gain = (dotProduct - deltaNorm2);
    float coef = (gain < 0.0f) ? 0.03f : 0.01f;
    m_Probability += (gain * coef);

    if(m_Probability < 0.0f)
    {
        m_Probability = 0.0f;
    }
    if(m_Probability >= 1.0f)
    {
        m_Probability = 1.0f;
    }
}

void AttachmentDetector::ResetProbability() NN_NOEXCEPT
{
    m_Probability = 0.0f;
}

float AttachmentDetector::GetProbability() const NN_NOEXCEPT
{
    return m_Probability;
}

bool AttachmentDetector::IsAttached() const NN_NOEXCEPT
{
    return (m_Probability > 0.9f);
}

}}} // namespace nn::hid::detail
