﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/applet/applet.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/TargetConfigs/build_Base.h>

#include "hid_AppletResourceUserId.h"

namespace nn { namespace hid { namespace detail {

::nn::applet::AppletResourceUserId GetAppletResourceUserId() NN_NOEXCEPT
{
#ifdef NN_BUILD_CONFIG_OS_HORIZON
    return ::nn::applet::GetAppletResourceUserId();
#else
    return ::nn::applet::AppletResourceUserId::GetInvalidId();
#endif
}

Result GetAppletResourceUserIdOfCallerApplet(::nn::applet::AppletResourceUserId* pOutValue) NN_NOEXCEPT
{
#ifdef NN_BUILD_CONFIG_OS_HORIZON
    NN_RESULT_DO(nn::applet::GetAppletResourceUserIdOfCallerApplet(pOutValue));
#else
    *pOutValue = ::nn::applet::AppletResourceUserId::GetInvalidId();
#endif
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
