﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#include "hid_IAbstractedPad.h"

namespace nn { namespace hid { namespace detail {

class AbstractedPadUsb final : public IAbstractedPad
{
private:
    static const AbstractedPadType s_Type = AbstractedPadType_Usb;

    //!< コントローラーの接続状態
    bool m_IsConnected;

    //!< Usb のポート番号
    size_t m_Port;

    //!< コントローラーの入力状態
    AbstractedPadState m_PadState;

    //!< インジケーターパターン
    uint8_t m_Pattern;

    //!< 入力無効化するボタン状態
    AbstractedPadButtonSet m_ButtonMask;

    //!< USB の Vendor ID
    uint16_t m_Vid;

    //!< USB の Product ID
    uint16_t m_Pid;

public:
    AbstractedPadUsb() NN_NOEXCEPT;
    virtual ~AbstractedPadUsb() NN_NOEXCEPT NN_OVERRIDE;

    //!< AbstractedPadType を取得する
    virtual AbstractedPadType GetType() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの接続状態を取得する
    virtual bool IsConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの電源状態を取得する
    virtual system::PowerInfo GetPowerInfo() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスのボタン/アナログスティックの入力状態を取得する
    virtual AbstractedPadState GetPadState() NN_NOEXCEPT NN_OVERRIDE;

    //!< 最後にボタンが押下された時間を取得する
    virtual bool GetButtonTriggerElapsedTime(nn::os::Tick* pOutTick, AbstractedPadButtonSet button) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターを制御する
    virtual void SetIndicator(uint8_t pattern, bool blink) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターパターンを取得する
    virtual uint8_t GetIndicator() NN_NOEXCEPT NN_OVERRIDE;

    //!< ケーブル接続されているかどうか
    virtual bool IsWired() NN_NOEXCEPT NN_OVERRIDE;

    //!< Usb の接続状態を取得します
    virtual bool IsUsbConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを接続状態に変更します
    virtual void Connect() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを切断する
    virtual void Detach() NN_NOEXCEPT NN_OVERRIDE;

    //!< バッテリーを搭載しているかどうか取得します
    virtual bool HasBattery() NN_NOEXCEPT NN_OVERRIDE;

    //!< プレイレポート用のデフォルトの情報を取得します
    virtual bool SetDeviceInfoOnPlayReportControllerUsage(system::PlayReportControllerUsage* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスを追加する
    void AttachDevice(size_t port, AbstractedPadId id, uint16_t vid, uint16_t pid) NN_NOEXCEPT;

    //!< デバイスを削除する
    void RemoveDevice() NN_NOEXCEPT;

    //!< Usb のポート番号を取得する
    size_t GetPort() NN_NOEXCEPT;

    //!< Input Report を設定します。
    void SetReport(const uint8_t* pReport, size_t length) NN_NOEXCEPT;

private:
    //!< デバイスの入力状態を更新する
    void UpdatePadState() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
