﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "hid_AbstractedPadIdPublisher.h"

namespace nn { namespace hid { namespace detail {

AbstractedPadIdPublisher::AbstractedPadIdPublisher() NN_NOEXCEPT
    : m_LatestId()
    , m_Mutex(false)
{
}

AbstractedPadId AbstractedPadIdPublisher::PublishId() NN_NOEXCEPT
{
    ::std::lock_guard<decltype(m_Mutex)
                      > locker(m_Mutex);
    ++m_LatestId;
    return m_LatestId;
}

}}} // namespace nn::hid::detail
