﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

#include "hid_AbstractedPadIdPublisher.h"
#include "hid_AbstractedGcAdapterPad.h"
#include "hid_ActivationCount.h"
#include "hid_GcAdapterDriver.h"
#include "hid_MultiWaitEvent.h"

namespace nn { namespace hid { namespace detail {

const int AbstractedGcAdapterPadCountMax = GcAdapterCountMax * GcPortPerAdapterCountMax;

//!< Usb のデバイス管理を担うマネージャーです
class AbstractedGcAdapterPadManager final
{
    NN_DISALLOW_COPY(AbstractedGcAdapterPadManager) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(AbstractedGcAdapterPadManager) NN_NOEXCEPT;

private:
    //!< AbstractedPad のリスト
    AbstractedGcAdapterPad* m_pPads[AbstractedGcAdapterPadCountMax];

    //!< AbstractedPad の数
    int m_PadCount;

    //!< アクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< AbstractedId パブリッシャー
    AbstractedPadIdPublisher* m_pIdPublisher;

    //!< 現在接続されている Adapter
    GcAdapterList m_Adapters;

    //!< Gc コントローラーアダプタードライバー
    GcAdapterDriver* m_pDriver;

public:
    AbstractedGcAdapterPadManager() NN_NOEXCEPT;

    ~AbstractedGcAdapterPadManager() NN_NOEXCEPT;

    //!< AbstractedId パブリッシャーをセットします
    void SetAbstractedPadIdPublisher(AbstractedPadIdPublisher* pPublisher) NN_NOEXCEPT;

    //!< AbstractedPadUsb をセットします
    void SetAbstractedGcAdapterPads(AbstractedGcAdapterPad* pPads, int count) NN_NOEXCEPT;

    //!< ドライバーを設定する
    void SetGcAdapterDriver(GcAdapterDriver* pDriver) NN_NOEXCEPT;

    //!< マネージャをアクティブ化します。
    ::nn::Result Activate() NN_NOEXCEPT;

    //!< マネージャを非アクティブ化します。
    ::nn::Result Deactivate() NN_NOEXCEPT;

    //!< デバイスの内部状態を更新します
    void Update();

private:
    //!< 切断されたアダプターを探索
    void CheckForDeviceDetach(GcAdapterList& newList, GcAdapterList& prevList) NN_NOEXCEPT;

    //!< デバイスをあいている AbstractedGcAdapterPad に追加する
    void AddDevice(GcControllerIndex index) NN_NOEXCEPT;

};

}}} // namespace nn::hid::detail
