﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/os/os_Tick.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/xcd/xcd.h>

#include "hid_AbstractedAutoPilotVirtualPadManager.h"
#include "hid_NpadId.h"

namespace nn { namespace hid { namespace detail {

AbstractedAutoPilotVirtualPadManager::AbstractedAutoPilotVirtualPadManager() NN_NOEXCEPT
    : m_PadCount(0)
{
    // 何もしない
}

AbstractedAutoPilotVirtualPadManager::~AbstractedAutoPilotVirtualPadManager() NN_NOEXCEPT
{
    // 何もしない
}

void AbstractedAutoPilotVirtualPadManager::SetAbstractedAutoPilotVirtualPads(AbstractedAutoPilotVirtualPad* pPads, int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pPads);
    NN_SDK_REQUIRES_GREATER(count, 0);
    NN_SDK_REQUIRES_LESS_EQUAL(count, AbstractedAutoPilotVirtualPadCount);
    for (int padIndex = 0; padIndex < count; padIndex++)
    {
        m_pPads[padIndex] = &pPads[padIndex];
    }
    m_PadCount = count;
}

::nn::Result AbstractedAutoPilotVirtualPadManager::SetAutoPilotState(
            const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId,
            const ::nn::hid::debug::AbstractedPadState& value ) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(virtualPadId >= 0 && virtualPadId < m_PadCount,
                           ResultAbstractedAutoPilotVirtualPadDeviceNumberOutOfRange());
    NN_RESULT_DO(m_pPads[virtualPadId]->SetAutoPilotState(value));

    NN_RESULT_SUCCESS;
}

::nn::Result AbstractedAutoPilotVirtualPadManager::UnsetAutoPilotState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(virtualPadId >= 0 && virtualPadId < m_PadCount,
                           ResultAbstractedAutoPilotVirtualPadDeviceNumberOutOfRange());
    NN_RESULT_DO(m_pPads[virtualPadId]->UnsetAutoPilotState());

    NN_RESULT_SUCCESS;
}

::nn::Result AbstractedAutoPilotVirtualPadManager::UnsetAllAutoPilotState() NN_NOEXCEPT
{
    for (int i = 0; i < m_PadCount; i++)
    {
        NN_RESULT_DO(m_pPads[i]->UnsetAutoPilotState());
    }

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
