﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "grcsrvOffscreen_ConvertCapsrvError.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_Result.h>
#include <nn/grc/grc_ResultPrivate.h>

namespace nn{ namespace grcsrv{ namespace offscreen{

    bool TryConvertCapsrvError(nn::Result* pOutValue, nn::Result result) NN_NOEXCEPT
    {
        if(!nn::capsrv::ResultAlbumError::Includes(result))
        {
            *pOutValue = result;
            return false;
        }

        if(nn::capsrv::ResultAlbumIsFull::Includes(result))
        {
            *pOutValue = nn::grc::ResultAlbumStorageFull();
        }
        else if(nn::capsrv::ResultAlbumFileCountLimit::Includes(result))
        {
            *pOutValue = nn::grc::ResultAlbumFileCountLimit();
        }
        else if(nn::capsrv::ResultAlbumFileSizeLimit::Includes(result))
        {
            *pOutValue = nn::grc::ResultAlbumFileSizeLimit();
        }
        else
        {
            *pOutValue = nn::grc::ResultAlbumStorageError();
        }

        return true;
    }

    nn::Result ConvertCapsrvError(nn::Result result) NN_NOEXCEPT
    {
        nn::Result out;
        (void)TryConvertCapsrvError(&out, result);
        return out;
    }

}}}
