﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nn/grc/grc_CommonTypes.h>
#include "../grcsrvOffscreen_Macro.h"

NN_PRAGMA_PUSH_WARNINGS
NN_GRCSRV_SUPPRESS_MOVIE_WARNINGS
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaMuxer.h>
NN_PRAGMA_POP_WARNINGS

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace detail{

    class MuxerMpeg4Writer
        : public android::MPEG4WriterStream
    {
    public:
        MuxerMpeg4Writer() NN_NOEXCEPT;

        void Initialize(nn::fs::FileHandle hFile) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result GetLastError() const NN_NOEXCEPT;

        virtual void SetPosition(int64_t offset) NN_NOEXCEPT NN_OVERRIDE;
        virtual void Write(const void* data, uint32_t size) NN_NOEXCEPT NN_OVERRIDE;

    private:
        nn::fs::FileHandle m_FileHandle;
        int64_t            m_CurrentPosition;
        nn::Result         m_LastError;
    };

    class MuxerHandler
    {
    public:
        enum class State
        {
            NotInitialized = 0,
            Initialized,
            Starting,
            Writing,
        };

    public:
        MuxerHandler() NN_NOEXCEPT;

        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result Start(nn::fs::FileHandle hFile) NN_NOEXCEPT;
        void Stop() NN_NOEXCEPT;

        nn::Result SetVideoFormat(const android::sp<android::AMessage>& pFormat) NN_NOEXCEPT;
        nn::Result SetAudioFormat(const android::sp<android::AMessage>& pFormat) NN_NOEXCEPT;

        // ビデオの回転方向（album::ImageOrientation 型）
        void SetVideoOrientation(uint32_t orientation) NN_NOEXCEPT;

        // 書込みの準備ができるまでブロックする
        // Writing になった場合成功を返す。
        // Stop() の呼出により中断された場合、 ResultInternalOffscreenAbortRequested を返す。
        nn::Result WaitForWriting() NN_NOEXCEPT;

        nn::Result StoreVideoFrame(
            const android::sp<android::ABuffer>& buffer,
            int64_t timestamp,
            uint32_t flags
        ) NN_NOEXCEPT;

        nn::Result StoreAudioFrame(
            const android::sp<android::ABuffer>& buffer,
            int64_t timestamp,
            uint32_t flags
        ) NN_NOEXCEPT;

    private:
        // 全トラックが設定済なら書込みを開始する。
        // 未設定のトラックがある場合、何もせずに「成功を返す」。
        nn::Result StartWritingIfAllTrackReadyImpl() NN_NOEXCEPT;

    private:
        State m_State;
        nn::os::MutexType m_Mutex;
        android::sp<android::MediaMuxer> m_pMuxer;
        MuxerMpeg4Writer m_Mpeg4Writer;

        nn::os::EventType m_WritingEvent; // State == Initialized または State == Writing の間シグナルする。
        int64_t m_VideoTrackId; // Format 未設定の場合 -1。
        int64_t m_AudioTrackId; // Format 未設定の場合 -1。

    };

}}}}

