﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace grcsrv { namespace detail {

class TransferMemoryHolder
{
private:

    bool m_Initialized = false;
    sf::NativeHandle m_WorkMemoryHandle;
    os::TransferMemoryType m_WorkMemoryTransferMemory;
    void* m_WorkMemory;
    size_t m_WorkMemorySize;

    void* m_AllocateHead;
    size_t m_AllocateRest;

public:

    Result Initialize(sf::NativeHandle&& workMemoryHandle, uint64_t workMemorySize) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    ~TransferMemoryHolder() NN_NOEXCEPT;

    void* AlignedAllocate(size_t alignment, size_t size) NN_NOEXCEPT;

};

}}}
