﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace grcsrv {

class Deactivatable
{
public:

    virtual bool Deactivate() NN_NOEXCEPT = 0;

};

class DeactivatableHolder
{
private:

    Deactivatable* m_P = nullptr;

public:

    void Set(Deactivatable* p) NN_NOEXCEPT;
    bool Deactivate() NN_NOEXCEPT;
};

}}
