﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_StaticAssert.h>

#include <nn/gfx/gfx_ShaderInfo.h>

namespace nn {
namespace gfx {

namespace {

static detail::Ptr< const void > ShaderInfoData::* const g_pShaderCodes[] =
{
    &ShaderInfoData::pVertexShaderCode,
    &ShaderInfoData::pHullShaderCode,
    &ShaderInfoData::pDomainShaderCode,
    &ShaderInfoData::pGeometryShaderCode,
    &ShaderInfoData::pPixelShaderCode,
    &ShaderInfoData::pComputeShaderCode
};

}

void ShaderInfo::SetDefault() NN_NOEXCEPT
{
    SetSeparationEnabled( false );
    SetCodeType( ShaderCodeType_Source );
    SetSourceFormat( ShaderSourceFormat_Glsl );
    SetBinaryFormat( 0 );
    SetShaderCodePtr( ShaderStage_Vertex, NULL );
    SetShaderCodePtr( ShaderStage_Hull, NULL );
    SetShaderCodePtr( ShaderStage_Domain, NULL );
    SetShaderCodePtr( ShaderStage_Geometry, NULL );
    SetShaderCodePtr( ShaderStage_Pixel, NULL );
    SetShaderCodePtr( ShaderStage_Compute, NULL );
}

void ShaderInfo::SetShaderCodePtr( ShaderStage shaderStage, const void* pCode ) NN_NOEXCEPT
{
    this->*g_pShaderCodes[ shaderStage ] = pCode;
}

const void* ShaderInfo::GetShaderCodePtr( ShaderStage shaderStage ) const NN_NOEXCEPT
{
    return this->*g_pShaderCodes[ shaderStage ];
}

NN_STATIC_ASSERT( sizeof( ShaderInfoData ) == 96 );
NN_STATIC_ASSERT( sizeof( ShaderCode ) == 32 );
NN_STATIC_ASSERT( sizeof( SourceArrayCode ) == 32 );

}
}
