﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_StaticAssert.h>

#include <nn/gfx/gfx_SamplerInfo.h>

namespace nn {
namespace gfx {

void SamplerInfo::SetDefault() NN_NOEXCEPT
{
    SetFilterMode( FilterMode_MinLinear_MagLinear_MipLinear );
    SetAddressU( TextureAddressMode_ClampToEdge );
    SetAddressV( TextureAddressMode_ClampToEdge );
    SetAddressW( TextureAddressMode_ClampToEdge );
    SetComparisonFunction( ComparisonFunction_Never );
    SetBorderColorType( TextureBorderColorType_White );
    SetMaxAnisotropy( 1 );
    SetMinLod( -1000.0f );
    SetMaxLod( 1000.0f );
    SetLodBias( 0.0f );
}

NN_STATIC_ASSERT( sizeof( SamplerInfoData ) == 32 );

}
}
