﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Windows.h>

#include <nn/os/os_MutexApi.h>

#include <nn/hws/hws_Window.h>

#include <nn/gfx/gfx_Interop-api.gl.4.h>
#include <nn/gfx/gfx_Device.h>

#include <nn/gfx/detail/gfx_Device-api.gl.4-os.win32.h>

#include "detail/gfx_CommonHelper.h"
#include "detail/gfx_GlHelper.h"
#include "detail/gfx_WglHelper.h"

namespace nn {
namespace gfx {

typedef ApiVariationGl4 Target;

void TInteroperation< Target >::ConvertToGfxDevice( TDevice< ApiVariationGl4 >* pOutGfxDevice, HGLRC__* hGlRc ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutGfxDevice );
    NN_SDK_REQUIRES_NOT_NULL( hGlRc );

    TDevice< Target >::DataType& obj = pOutGfxDevice->ToData();
    obj.state = TDevice< Target >::DataType::State_Initialized;
    obj.flags.SetBit( TDevice< Target >::DataType::Flag_Shared, true );
    obj.renderingContext.hGlRc = hGlRc;

    obj.hWnd = nn::hws::FindWindow( "GfxSystemDisplay" ).Get();
    NN_SDK_ASSERT_NOT_NULL( obj.hWnd );

    obj.hDc = ::GetDC(  static_cast< HWND >( obj.hWnd ) );
    NN_SDK_ASSERT_NOT_NULL( obj.hDc );

    NN_GFX_CALL_NNOS_FUNCTION( nn::os::InitializeMutex(
        &obj.renderingContext.mutex, true, nn::os::MutexLockLevelMax ) );

    ::glewExperimental = TRUE;
    detail::Wgl::MakeCurrent( obj.hDc, obj.renderingContext.hGlRc );
    GLenum glewResult = ::glewInit();
    NN_UNUSED( glewResult );
    NN_SDK_ASSERT( glewResult == GLEW_OK, "glewInit: %s\n", ::glewGetErrorString( glewResult ) );

    GLint totalAttachments = -1;
    NN_GFX_CALL_GL_FUNCTION( ::glGetIntegerv( GL_MAX_COLOR_ATTACHMENTS, &totalAttachments ) );
    obj.maxColorAttachments = totalAttachments;

    GLint alignmentConstantBuffer = -1;
    NN_GFX_CALL_GL_FUNCTION( ::glGetIntegerv(
        GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT, &alignmentConstantBuffer ) );
    obj.alignmentConstantBuffer = static_cast< uint32_t >( alignmentConstantBuffer );
    GLint alignmentUnorderedAccessBuffer = -1;
    NN_GFX_CALL_GL_FUNCTION( ::glGetIntegerv(
        GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT, &alignmentUnorderedAccessBuffer ) );
    obj.alignmentUnorderedAccessBuffer = static_cast< uint32_t >( alignmentUnorderedAccessBuffer );

    detail::Wgl::MakeCurrent( obj.hDc, obj.renderingContext.hGlRc );
    ::glGetError();
    ::wglMakeCurrent( NULL, NULL );
}

}
}
