﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_Config.h>

#if !defined( NN_BUILD_CONFIG_OS_SUPPORTS_WIN32 )
    #error
#endif

#include <nn/nn_Windows.h>

namespace nn {
namespace gfx {
namespace detail {

class Wgl
{
public:

static HGLRC CreateGlRc( HDC hDc, HGLRC hSharedRc, int majorVersion, int minorVersion, bool debugMode ) NN_NOEXCEPT;

// 呼ぶ前に対象のレンダリングコンテキストを非カレントにしておく
static void DeleteGlRc( HGLRC hRc ) NN_NOEXCEPT;

static int SetPixelFormat( HDC hDc ) NN_NOEXCEPT;
static int SetPixelFormat( HDC hDc, const PIXELFORMATDESCRIPTOR& pfd ) NN_NOEXCEPT;

static bool SetSwapInterval( int interval ) NN_NOEXCEPT;

static int GetSwapInterval() NN_NOEXCEPT;

static void GetWidthAndHeight( int* pOutWidth, int* pOutHeight, HDC hDc ) NN_NOEXCEPT;

static void* GetProcAddress( const char* name ) NN_NOEXCEPT;

static void MakeCurrent( HDC hDc, HGLRC hGlRc ) NN_NOEXCEPT;

};

}
}
}
