﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/gfx_SyncInfo.h>

#include <nn/gfx/detail/gfx_Sync-api.d3d.11.h>
#include <nn/gfx/detail/gfx_Misc.h>
#include <nn/gfx/detail/gfx_Device-api.d3d.11.h>
#include <nn/gfx/detail/gfx_Queue-api.d3d.11.h>

#include "gfx_D3dHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationD3d11 Target;

FenceImpl< Target >::FenceImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
}

FenceImpl< Target >::~FenceImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized );
}

void FenceImpl< Target >::Initialize( DeviceImpl< Target >* pDevice, const InfoType& info ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pDevice );
    NN_SDK_REQUIRES( this->state == State_NotInitialized );
    NN_UNUSED( info );
    NN_UNUSED( pDevice );

    this->pQueue = NULL;
    this->flags.Clear();
    this->state = State_Initialized;
}

void FenceImpl< Target >::Finalize( DeviceImpl< Target >* pDevice ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pDevice );
    NN_SDK_REQUIRES( this->state == State_Initialized );
    NN_UNUSED( pDevice );

    this->pQueue = NULL;
    this->state = State_NotInitialized;
}

bool FenceImpl< Target >::IsSignaled() const NN_NOEXCEPT
{
    NN_SDK_ASSERT( IsInitialized( *this ) );

    if( this->flags.GetBit( Flag_Signaled ) )
    {
        return true;
    }

    return false;
}

SyncResult FenceImpl< Target >::Sync( TimeSpan timeout ) const NN_NOEXCEPT
{
    NN_SDK_ASSERT( IsInitialized( *this ) );
    NN_UNUSED( timeout );

    return SyncResult_Success;
}

SemaphoreImpl< Target >::SemaphoreImpl() NN_NOEXCEPT
{
    this->state = State_NotInitialized;
}

SemaphoreImpl< Target >::~SemaphoreImpl() NN_NOEXCEPT
{
    NN_SDK_ASSERT( this->state == State_NotInitialized );
}

void SemaphoreImpl< Target >::Initialize( DeviceImpl< Target >* pDevice, const InfoType& info ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pDevice );
    NN_SDK_REQUIRES( this->state == State_NotInitialized );
    NN_UNUSED( pDevice );
    NN_UNUSED( info );

    this->pQueue = NULL;
    this->flags.Clear();
    this->state = State_Initialized;
}

void SemaphoreImpl< Target >::Finalize( DeviceImpl< Target >* pDevice ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( this->state == State_Initialized );
    NN_UNUSED( pDevice );

    this->state = State_NotInitialized;
}

}
}
}
