﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_COS )
    #error
#endif

#include <nn/nn_SdkAssert.h>

#include <nn/gfx/detail/gfx_Core-api.gx.2.h>

#include "gfx_GxHelper.h"

namespace nn {
namespace gfx {
namespace detail {

DisplayInfo displays[2];

namespace {

bool g_Initialized = false;

void SetupDisplayHandles()
{
    static const u32 s_TvScanModeTable[] = {
           0,    0, // GX2_TV_SCAN_MODE_NONE,
         720,  576, // GX2_TV_SCAN_MODE_576I
         720,  480, // GX2_TV_SCAN_MODE_480I
         720,  480, // GX2_TV_SCAN_MODE_480P
        1280,  720, // GX2_TV_SCAN_MODE_720P
           0,    0, // GX2_TV_SCAN_MODE_RESERVED
        1920, 1080, // GX2_TV_SCAN_MODE_1080I
        1920, 1080, // GX2_TV_SCAN_MODE_1080P
    };

    // Create Display Handle for TV
    displays[0].name = "GfxMainDisplay";
    displays[0].tvScanMode = NN_GFX_CALL_GX_FUNCTION( GX2GetSystemTVScanMode() );
    displays[0].width  = s_TvScanModeTable[ 2 * displays[0].tvScanMode ];
    displays[0].height = s_TvScanModeTable[ 2 * displays[0].tvScanMode + 1 ];
    displays[0].isTV = true;
    displays[0].isEnabled = false;

    // Create Display Handle for DRC
    displays[1].name = "GfxDrcDisplay";
    displays[1].width  = 854;
    displays[1].height = 480;
    displays[1].isTV = false;
    displays[1].isEnabled = false;
}

}

typedef ApiVariationGx2 Target;

template<>
void Initialize< Target >() NN_NOEXCEPT
{
    NN_UNUSED( g_Initialized );
    NN_SDK_REQUIRES( !g_Initialized );
    NN_UNUSED( g_Initialized );

    SetupDisplayHandles();

    // Allow for Spark Captures (requires gx2spark.a to be linked)
    NN_GFX_CALL_GX_FUNCTION( GX2DebugCaptureInit( NULL ) );

    // Initialize GX2 using the defaults.
    NN_GFX_CALL_GX_FUNCTION( GX2Init( NULL ) );

    NN_GFX_CALL_GX_FUNCTION( GX2SetEventCallback(
        GX2_CB_EVENT_DL_OVERRUN, Gx::CallbackFunction, &Gx::g_DisplayListOverrun ) );

    g_Initialized = true;
}

template<>
void Finalize< Target >() NN_NOEXCEPT
{
    NN_SDK_REQUIRES( g_Initialized );

    NN_GFX_CALL_GX_FUNCTION( GX2Shutdown() );

    g_Initialized = false;
}

}
}
}
