﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Windows.h>

#include <nn/nn_Macro.h>

#if !defined( NN_BUILD_CONFIG_OS_WIN32 )
#error
#endif

#include <nn/nn_SdkAssert.h>

#include <nn/hws/hws_Window.h>

#include <nn/gfx/detail/gfx_Core-api.gl.4.h>

#include "gfx_CommonHelper.h"

namespace nn {
namespace gfx {
namespace detail {

namespace {

bool g_Initialized = false;

}

typedef ApiVariationGl4 Target;

template<>
void Initialize< Target >() NN_NOEXCEPT
{
    NN_SDK_REQUIRES( !g_Initialized );

    nn::hws::WindowHandle hWindow;
    nn::hws::CreateWindowArg arg;
    arg.SetWidth( 1280 );
    arg.SetHeight( 720 );
    arg.SetTitle( "GfxSystemDisplay" );
    arg.SetWindowName( "GfxSystemDisplay" );
    hWindow = nn::hws::CreateWindow( arg );
    NN_SDK_ASSERT( hWindow.IsValid() );

    arg.SetTitle( "GfxQueueSystemDisplay" );
    arg.SetWindowName( "GfxQueueSystemDisplay" );
    hWindow = nn::hws::CreateWindow( arg );
    NN_SDK_ASSERT( hWindow.IsValid() );
    NN_UNUSED( hWindow );

    g_Initialized = true;
}

template<>
void Finalize< Target >() NN_NOEXCEPT
{
    NN_SDK_REQUIRES( g_Initialized );

    nn::hws::WindowHandle hWindow;
    hWindow = nn::hws::FindWindow( "GfxSystemDisplay" );
    if( hWindow.IsValid() )
    {
        nn::hws::DestroyWindow( hWindow );
    }

    hWindow = nn::hws::FindWindow( "GfxQueueSystemDisplay" );
    if( hWindow.IsValid() )
    {
        nn::hws::DestroyWindow( hWindow );
    }

    g_Initialized = false;
}

}
}
}
