﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/ens_Api.h>
#include <nn/ens/detail/ens_Common.h>
#include <nn/ens/detail/core/ens_ServiceThread.h>
#include <nn/ens/detail/core/task/ens_TaskGenerateCredential.h>

namespace nn { namespace ens {

namespace
{
    ServiceThreadContext g_ServiceThreadContext;
}

void StartServiceLoop(const char* pServerKey, void* pBuffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pServerKey);
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_GREATER(bufferSize, RequiredMemorySizeMin);

    detail::core::CreateAllocator(pBuffer, RequiredMemorySizeMin);

    detail::core::SetServerKey(pServerKey);

    Bit8* pWorkBuffer = reinterpret_cast<Bit8*>(pBuffer) + RequiredMemorySizeMin;

    g_ServiceThreadContext.SetBuffer(pWorkBuffer, bufferSize - RequiredMemorySizeMin);

    detail::core::StartServiceLoop(g_ServiceThreadContext);
    detail::core::UnregisterTaskAll();

    detail::core::DestroyAllocator();
}

void StopServiceLoop() NN_NOEXCEPT
{
    detail::core::StopServiceLoop(g_ServiceThreadContext);
}

void GenerateCredential(AsyncContext* pOutContext,
    Credential* pOutCredential, const char* pToken) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutContext);
    NN_SDK_REQUIRES_NOT_NULL(pOutCredential);
    NN_SDK_REQUIRES_NOT_NULL(pToken);

    NN_DETAIL_ENS_CREATE_TASK(pOutContext, pTask, detail::core::task::TaskGenerateCredential);

    pTask->SetNetworkServiceAccountIdToken(pToken);

    pTask->SetParameter(pOutCredential);

    detail::core::RegisterTask(pTask, pOutContext);
}

}}
