﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/core/task/ens_TaskGenerateCredential.h>
#include <nn/ens/detail/core/ens_HttpRequestHeader.h>
#include <nn/ens/detail/util/ens_MessagePackReader.h>
#include <nn/ens/detail/util/ens_ResponseStructureReader.h>

namespace nn { namespace ens { namespace detail { namespace core { namespace task {

TaskGenerateCredential::TaskGenerateCredential() NN_NOEXCEPT
    : m_pOutCredential(nullptr)
{
}

TaskGenerateCredential::~TaskGenerateCredential() NN_NOEXCEPT
{
}

void TaskGenerateCredential::SetParameter(Credential* pOutCredential) NN_NOEXCEPT
{
    m_pOutCredential = pOutCredential;
}

nn::Result TaskGenerateCredential::Main() NN_NOEXCEPT
{
    NN_RESULT_DO(StepGenerate());

    NN_RESULT_SUCCESS;
}

nn::Result TaskGenerateCredential::StepGenerate() NN_NOEXCEPT
{
    NN_DETAIL_ENS_SCOPED_ACQUIRE_HTTP_CONNECTION(pCurl);

    char url[256] = {};
    detail::core::MakeUrl(url, sizeof (url), "api", "/api/v1/users");

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_CUSTOMREQUEST, "POST"));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_URL, url));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_POSTFIELDS, ""));

    detail::core::HttpRequestHeader header;

    // 入力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        NN_RESULT_THROW_UNLESS(IsAsyncContextRegistered(), ResultInvalidState());

        NN_RESULT_DO(header.Add("Authorization", "Bearer %.*s",
            static_cast<int>(nn::account::NetworkServiceAccountIdTokenLengthMax), GetNetworkServiceAccountIdToken()));
        NN_RESULT_DO(header.Add("Content-Type", "application/x-msgpack"));
    }

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_HTTPHEADER, header.Get()));

    NN_RESULT_DO(Perform());

    NN_DETAIL_ENS_DUMP_RESPONSE(detail::util::MessagePackReader, GetResponse(), GetResponseSize());

    // 出力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        NN_RESULT_THROW_UNLESS(IsAsyncContextRegistered(), nn::ens::ResultInvalidState());

        detail::util::ResponseStructureReader<2> reader;

        reader.Add("$.id",
            &m_pOutCredential->userId.value);
        reader.Add("$.password",
            m_pOutCredential->_password, sizeof (m_pOutCredential->_password));

        NN_RESULT_THROW_UNLESS(reader.Read<detail::util::MessagePackReader>(GetResponse(), GetResponseSize()), ResultInvalidResponse());
    }

    NN_RESULT_SUCCESS;
}

}}}}}
