﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/app/acbaa/task/ens_TaskPostMyDesign.h>
#include <nn/ens/detail/core/ens_HttpRequestHeader.h>
#include <nn/ens/detail/util/ens_MessagePackReader.h>
#include <nn/ens/detail/util/ens_MessagePackWriter.h>
#include <nn/ens/detail/util/ens_ResponseStructureReader.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

TaskPostMyDesign::TaskPostMyDesign() NN_NOEXCEPT
    : m_pOutId(nullptr)
{
}

TaskPostMyDesign::~TaskPostMyDesign() NN_NOEXCEPT
{
}

void TaskPostMyDesign::SetParameter(MyDesignId* pOutId, const SendBuffer& metadata, const SendBuffer& body) NN_NOEXCEPT
{
    m_pOutId = pOutId;

    m_Metadata = metadata;
    m_Body = body;
}

nn::Result TaskPostMyDesign::ExecuteSteps() NN_NOEXCEPT
{
    NN_RESULT_DO(StepPost());

    NN_RESULT_SUCCESS;
}

nn::Result TaskPostMyDesign::StepPost() NN_NOEXCEPT
{
    NN_DETAIL_ENS_SCOPED_ACQUIRE_HTTP_CONNECTION(pCurl);

    char url[256] = {};
    detail::core::MakeUrl(url, sizeof (url), "api", "/api/v1/designs");

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_CUSTOMREQUEST, "POST"));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_URL, url));

    detail::core::HttpRequestHeader header;

    // 入力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        NN_RESULT_THROW_UNLESS(IsAsyncContextRegistered(), ResultInvalidState());

        detail::util::MessagePackWriter writer;

        writer.SetBuffer(GetRequestBuffer(), GetRequestBufferSize());

        NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteMap(!m_Metadata.IsNull() ? 2 : 1));
        {
            NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteKey("body"));
            NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteValue(m_Body));

            if (!m_Metadata.IsNull())
            {
                NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteKey("meta"));
                NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteValue(m_Metadata));
            }
        }

        NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_POSTFIELDS, writer.GetBuffer()));
        NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_POSTFIELDSIZE, writer.GetWrittenSize()));
    }

    NN_RESULT_DO(header.Add("Authorization", "Bearer %s", GetAuthToken().value));
    NN_RESULT_DO(header.Add("Content-Type", "application/x-msgpack"));

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_HTTPHEADER, header.Get()));

    NN_RESULT_DO(Perform());

    NN_DETAIL_ENS_DUMP_RESPONSE(detail::util::MessagePackReader, GetResponse(), GetResponseSize());

    // 出力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        NN_RESULT_THROW_UNLESS(IsAsyncContextRegistered(), ResultInvalidState());

        detail::util::ResponseStructureReader<1> reader;

        reader.Add("$.id",
            &m_pOutId->value);

        NN_RESULT_THROW_UNLESS(reader.Read<detail::util::MessagePackReader>(GetResponse(), GetResponseSize()), ResultInvalidResponse());
    }

    NN_RESULT_SUCCESS;
}

}}}}}
