﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include <nw/eft/eftcom_Guid.h>
#include <nw/eft/typeDef2.h>
#include <cstdio>


namespace nw     {
namespace eftcom {

//---------------------------------------------------------------------------------------------
//      コンストラクタです.
//---------------------------------------------------------------------------------------------
Guid::Guid()
{
    /* DO_NOTHING */
    for( int i=0; i<16; ++i )
    {
        data[i] = 0;
    }
}

//---------------------------------------------------------------------------------------------
//      引数付きコンストラクタです.
//---------------------------------------------------------------------------------------------
Guid::Guid( unsigned char dat[16] )
{
    for( int i=0; i<16; ++i )
    {
        data[i] = dat[i];
    }
}

//---------------------------------------------------------------------------------------------
//      代入演算子です.
//---------------------------------------------------------------------------------------------
Guid& Guid::operator = ( const Guid& value )
{
    for( int i=0; i<16; ++i )
    {
        data[i] = value.data[i];
    }

    return (*this);
}

//---------------------------------------------------------------------------------------------
//      等価比較演算子です.
//---------------------------------------------------------------------------------------------
bool Guid::operator == ( const Guid& value ) const
{
    for( int i=0; i<16; ++i )
    {
        if ( data[i] != value.data[i] )
        {
            return false;
        }
    }

    return true;
}

//---------------------------------------------------------------------------------------------
//      非等価比較演算子です.
//---------------------------------------------------------------------------------------------
bool Guid::operator != ( const Guid& value ) const
{
    for( int i=0; i<16; ++i )
    {
        if ( data[i] != value.data[i] )
        {
            return true;
        }
    }

    return false;
}


//---------------------------------------------------------------------------------------------
//      文字列に変換します.
//---------------------------------------------------------------------------------------------
char* Guid::GetString( char* text, unsigned int size )
{
    EFT_ASSERT( size >= GUID_STRING_BUFF_SIZE );
    memset( text, 0, size );
#if EFT_IS_WIN
    sprintf_s( text, size, "%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x",
#else
    sprintf( text, "%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x",
#endif
        data[ 0], data[ 1], data[2], data[3],
        data[ 4], data[ 5],
        data[ 6], data[ 7],
        data[ 8], data[ 9],
        data[10], data[11], data[12], data[13], data[14], data[15] );

    return text;
}

} // namespace eftcom
} // namespace nw
