﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/eft/eft2_Misc.h>
#include <nw/eft/eft2_Random.h>

namespace nw   {
namespace eft2 {


//------------------------------------------------------------------------------
//      static
//------------------------------------------------------------------------------
nw::math::VEC3* Random::g_Vec3Tbl           = NULL;
nw::math::VEC3* Random::g_NormalizedVec3Tbl = NULL;

// グローバルランダム
RandomGenerator Random::g_Random;

// グローバルなシード
bool Random::g_UseGlobalSeed = false;
u32  Random::g_GlobalSeed    = 256;

//------------------------------------------------------------------------------
// グローバルランダム取得関数
//------------------------------------------------------------------------------
RandomGenerator* Random::GetGlobalRandom()
{
    return &Random::g_Random;
}

//------------------------------------------------------------------------------
//      生成
//------------------------------------------------------------------------------
Random::Random()
{
    m_Vec3RndIx           = static_cast<u16>( g_Random.GetU32() );
    m_NormalizedVec3RndIx = static_cast<u16>( g_Random.GetU32() );
    m_Rnd                 = g_Random.GetU32();
}

//------------------------------------------------------------------------------
//      乱数テーブル作成
//------------------------------------------------------------------------------
void Random::Initialize()
{
    RandomGenerator rnd( 12345679 );

    g_Vec3Tbl            = static_cast<nw::math::VEC3 *>( AllocFromStaticHeap( sizeof(nw::math::VEC3) * cNumVec3Tbl ) );
    g_NormalizedVec3Tbl  = static_cast<nw::math::VEC3 *>( AllocFromStaticHeap( sizeof(nw::math::VEC3) * cNumVec3Tbl ) );

    for( int i=0 ; i < cNumVec3Tbl ; i++ )
    {

        g_Vec3Tbl[i].x = rnd.GetF32() * 2.0f - 1.0f;
        g_Vec3Tbl[i].y = rnd.GetF32() * 2.0f - 1.0f;
        g_Vec3Tbl[i].z = rnd.GetF32() * 2.0f - 1.0f;

        g_NormalizedVec3Tbl[i].x = rnd.GetF32() * 2.0f - 1.0f;
        g_NormalizedVec3Tbl[i].y = rnd.GetF32() * 2.0f - 1.0f;
        g_NormalizedVec3Tbl[i].z = rnd.GetF32() * 2.0f - 1.0f;
        g_NormalizedVec3Tbl[i].Normalize();
    }
}

//------------------------------------------------------------------------------
//      乱数テーブル破棄
//------------------------------------------------------------------------------
void Random::Finalize()
{
    FreeFromStaticHeap( g_Vec3Tbl );
    FreeFromStaticHeap( g_NormalizedVec3Tbl );

    g_Vec3Tbl = NULL;
    g_NormalizedVec3Tbl = NULL;
}

} // namespace eft2
} // namespace nw
