﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/nn_TimeSpan.h>")]
    public struct TimeSpan
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/nn_Result.h>")]
    [CppFullName("nn::Result")]
    public struct ResultArgument
    {
    }
}

namespace nn.ncm
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/ncm/ncm_ProgramId.h>")]
    public struct ProgramId
    {
    }

    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/ncm/ncm_ContentMetaId.h>")]
    public struct ApplicationId
    {
    }
}

namespace nn.account
{
    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/account/account_Types.h>")]
    public struct Uid
    {
    }
}

namespace nn.applet
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/applet/applet_Types.h>")]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath("<nn/applet/applet.h>")]
    [Nintendo.ServiceFramework.Applet.CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.vi.fbshare
{
    [CppRefPath("<nn/vi/fbshare/vi_SharedBufferHandle.h>")]
    [ExternalStruct(8, 8)]
    public struct SharedBufferHandle { }
}

namespace nn.capsrv
{
    [ExternalStruct(32, 8)]
    [CppRefPath("<nn/capsrv/capsrv_ApplicationAlbumEntry.h>")]
    public struct ApplicationAlbumEntry
    {
    }

    [ExternalStruct(48, 8)]
    [CppRefPath("<nn/capsrv/capsrv_ApplicationAlbumFileEntry.h>")]
    public struct ApplicationAlbumFileEntry
    {
    }

    [ExternalStruct(32, 8)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumEntry.h>")]
    public struct AlbumEntry
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumFileDescription.h>")]
    public struct AlbumFileDescriptionType
    {
    }

    [ExternalStruct(24, 8)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumFileId.h>")]
    public struct AlbumFileId
    {
    }

    [ExternalStruct(8, 2)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumFileDateTime.h>")]
    public struct AlbumFileDateTime
    {
    }

    [ExternalStruct(1, 1)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumStorage.h>")]
    public struct AlbumStorageType
    {
    }

    [ExternalStruct(1, 1)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumFileContents.h>")]
    public struct AlbumFileContentsType
    {
    }

    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumFileContents.h>")]
    public struct AlbumFileContentsFlag
    {
    }

    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/capsrv/capsrv_EditedScreenShotInfo.h>")]
    public struct EditedScreenShotInfo
    {
    }

    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/capsrv/capsrv_AlbumCacheData.h>")]
    public struct AlbumCacheData
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/capsrv/capsrv_ScreenShotSize.h>")]
    public struct ScreenShotSizeType
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/capsrv/capsrv_ScreenShotOrientation.h>")]
    public struct ScreenShotOrientationType
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/capsrv/capsrv_OverlayNotificationRequest.h>")]
    public struct OverlayNotificationRequestType
    {
    }

    [ExternalStruct(32, 8)]
    [CppRefPath("<nn/capsrv/capsrv_ScreenShotDecodeOption.h>")]
    public struct ScreenShotDecodeOption
    {
    }

    [ExternalStruct(1024, 1)]
    [LargeData(true)]
    [CppRefPath("<nn/capsrv/capsrv_AppletData.h>")]
    public struct AppletData
    {
    }

    [ExternalStruct(1028, 4)]
    [LargeData(true)]
    [CppRefPath("<nn/capsrv/capsrv_ApplicationData.h>")]
    public struct ApplicationData
    {
    }

    [ExternalStruct(136, 8)]
    [LargeData(true)]
    [CppRefPath("<nn/capsrv/capsrv_SystemReservedInfo.h>")]
    public struct UserIdList
    {
    }

    namespace detail
    {
        [ExternalStruct(64, 4)]
        [CppRefPath("<nn/capsrv/capsrv_ScreenShotAttribute.h>")]
        public struct ScreenShotAttributeEx0
        {
        }

        [ExternalStruct(24 * 2, 8)]
        [CppRefPath("<nn/capsrv/capsrv_AlbumUsage.h>")]
        public struct AlbumUsage2
        {
        }

        [ExternalStruct(24 * 3, 8)]
        [CppRefPath("<nn/capsrv/capsrv_AlbumUsage.h>")]
        public struct AlbumUsage3
        {
        }

        [ExternalStruct(24 * 16, 8)]
        [LargeData(true)]
        [CppRefPath("<nn/capsrv/capsrv_AlbumUsage.h>")]
        public struct AlbumUsage16
        {
        }

        [ExternalStruct(8, 8)]
        [CppRefPath("<nn/capsrv/capsrv_AlbumMovieReadStreamHandle.h>")]
        public struct AlbumMovieReadStreamHandleType
        {
        }

        [ExternalStruct(8, 8)]
        [CppRefPath("<nn/capsrv/capsrv_AlbumMovieWriteStreamHandle.h>")]
        public struct AlbumMovieWriteStreamHandleType
        {
        }
    }

    namespace sf
    {
        [ExternalStruct(1104, 8)]
        [LargeData(true)]
        [CppRefPath("<nn/capsrv/sf/capsrv_ServiceType.h>")]
        public struct LoadAlbumScreenShotImageOutputEx1
        {
        }

        [ExternalStruct(1280, 8)]
        [LargeData(true)]
        [CppRefPath("<nn/capsrv/sf/capsrv_ServiceType.h>")]
        public struct LoadAlbumScreenShotImageOutputForApplication
        {
        }
    }
}

// -------------------------------------------------Port----Client--------------Version------------------------
// 00001: CaptureRawImageRgba32IntoArray            sc  for am                  internal, deprecated
// 00002: CaptureRawImageRgba32IntoArrayWithTimeout sc  for am                  internal, deprecated
// 00003: AttachSharedBufferToCaptureModule         sc  for am                  internal
// 00004: (DetachSharedBufferFromCaptureModule)     sc  for am                  internal
// 00005: CaptureRawImageToAttachedSharedBuffer     sc  for am                  internal
// 01001: (RequestTakingScreenShot)                 sc  for am                  internal, deleted
// 01002: (RequestTakingScreenShotWithTimeout)      sc  for am                  internal, deleted
// 01003: (RequestTakingScreenShotEx0)              sc  for am                  internal, deleted
// 01004: RequestTakingScreenShotEx1                sc  for am                  internal
// 01009: CancelTakingScreenShot                    sc  for am                  internal
// 01011: NotifyTakingScreenShotRefused             sc  for am                  internal
// 01012: NotifyTakingScreenShotFailed              sc  for am                  internal
// 01101: SetupOverlayMovieThumbnail                sc  for grc                 internal
// 01102: CreateProtoMovieMetaDataNv12              sc  for grc                 internal
// 01103: CreateProtoMovieMetaDataNv12Ex0           sc  for grc                 internal
// 01104: CreateProtoMovieMetaDataRgba              sc  for grc                 internal
// 01105: CreateProtoMovieMetaDataNv12Ex1           sc  for grc                 internal
// 01106: CreateProtoMovieMetaDataNv12Ex2           sc  for grc                 internal
// 01107: CreateProtoMovieMetaDataRgbaEx2           sc  for grc                 internal
// 01201: OpenRawScreenShotReadStreamForDevelop     sc  for tma                 internal, !prod
// 01202: CloseRawScreenShotReadStreamForDevelop    sc  for tma                 internal, !prod
// 01203: ReadRawScreenShotReadStreamForDevelop     sc  for tma                 internal, !prod
// -------------------------------------------------Port----Client--------------Version------------------------
// 00201: SaveScreenShot                            ss  for Ocean               2.0.0 NUP
// 00202: SaveEditedScreenShot                      ss  for Ocean               2.0.0 NUP
// 00203: SaveScreenShotEx0                         ss  for Ocean               3.0.0 NUP
// 00204: SaveEditedScreenShotEx0                   ss  for Ocean               3.0.0 NUP
// 00205: (SaveScreenShotEx1)
// 00206: SaveEditedScreenShotEx1                   ss  for Ocean               4.0.0 NUP   : AppletData 対応版
// 00208: SaveScreenShotOfMovieEx1                  ss  for Ocean               5.0.0 NUP : 動画から静止画の切出用
// -------------------------------------------------Port----Client--------------Version------------------------
// 00201: SaveScreenShot                            su  for Application         3.0.0 NUP
// 00203: SaveScreenShotEx0                         su  for Application         3.0.0 NUP
// 00204: (SaveEditedScreenShotEx0)
// 00205: (SaveScreenShotEx1)
// 00206: (SaveEditedScreenShotEx1)
// -------------------------------------------------Port----Client--------------Version------------------------
// 02001: NotifyAlbumStorageIsAvailable             c   for ns                  internal
// 02002: NotifyAlbumStorageIsUnavailable           c   for ns                  internal
// 02011: RegisterAppletResourceUserId              c   for am                  internal
// 02012: UnregisterAppletResourceUserId            c   for am                  internal
// 02013: GetApplicationIdFromAruid                 c   for capsrv/screenshot   internal
// 02014: CheckApplicationIdRegistered              c   for capsrv/screenshot   internal
// 02101: GenerateCurrentAlbumFileId                c   for capsrv/screenshot   internal
// 02201: SaveAlbumScreenShotFile                   c   for capsrv/screenshot   internal : 3NUP まで
// 02202: SaveAlbumScreenShotFileEx                 c   for capsrv/screenshot   internal : 4NUP から
// 02301: SetOverlayScreenShotThumbnailData         c   for capsrv/screenshot   internal
// 02302: SetOverlayMovieThumbnailData              c   for capsrv/movie        internal(grc->vi->capsrv)
//# 02000番台: 動画特化
//  -> 動画読込セッション
//  -> 動画書込セッション
//# 60000 番台: セッション作成
// 60001: OpenControlSession                        c   for grc                 internal
// -------------------------------------------------Port----Client--------------Version------------------------
// 00000: GetAlbumFileCount                         a   for Ocean               Preinstall
// 00001: GetAlbumFileList                          a   for Ocean               Preinstall
// 00002: LoadAlbumFile                             a   for Ocean               Preinstall
// 00003: DeleteAlbumFile                           a   for Ocean               Preinstall
// 00004: StorageCopyAlbumFile                      a   for Ocean               Preinstall
// 00005: IsAlbumMounted                            a   for Ocean               Preinstall
// 00006: GetAlbumUsage                             a   for Ocean               Preinstall
// 00007: GetAlbumFileSize                          a   for Ocean               Preinstall
// 00008: LoadAlbumFileThumbnail                    a   for Ocean               Preinstall
// 00009: LoadAlbumScreenShotImage                  a   for Ocean               2.0.0 NUP  : オプション指定なし版
// 00010: LoadAlbumScreenShotThumbnailImage         a   for Ocean               2.0.0 NUP  : オプション指定なし版
// 00011: GetAlbumEntryFromApplicationAlbumEntry    a   for Ocean               2.0.0 NUP
// 00012: LoadAlbumScreenShotImageEx                a   for Ocean               3.0.0 NUP  : ScreenShotDecodeOption 版
// 00013: LoadAlbumScreenShotThumbnailImageEx       a   for Ocean               3.0.0 NUP  : ScreenShotDecodeOption 版
// 00014: LoadAlbumScreenShotImageEx0               a   for Ocean               3.0.0 NUP  : Attribute 対応版
// 00015: GetAlbumUsage3                            a   for Ocean               4.0.0 NUP  : 没
// 00016: GetAlbumMountResult                       a   for Ocean               4.0.0 NUP  : Mount 失敗理由を返す
// 00017: GetAlbumUsage16                           a   for Ocean               4.0.0 NUP  : 複数 AlbumFileContents 対応版
// 00100: GetAlbumFileCountEx0                      a   for Ocean               5.0.0 NUP  : AlbumFileContentsFlag 対応版
// 00101: GetAlbumFileListEx0                       a   for Ocean               5.0.0 NUP  : AlbumFileContentsFlag 対応版
// 00301: GetLastOverlayScreenShotThumbnail         a   for Ocean               Preinstall
// 00302: GetLastOverlayMovieThumbnail              a   for Ocean               4.0.0 NUP
// 00401: GetAutoSavingStorage                      a   for Ocean               Preinstall
// 00501: GetRequiredStorageSpaceSizeToCopyAll      a   for Ocean               Preinstall
//# 01000番台: 静止画特化
// 01001: GetAlbumScreenShotThumbnailImageEx0       a   for Ocean               3.0.0 NUP  : Attribute 対応版
// 01002: LoadAlbumScreenShotImageEx1               a   for Ocean               4.0.0 NUP  : Attribute, AppletData 対応版
// 01003: GetAlbumScreenShotThumbnailImageEx1       a   for Ocean               4.0.0 NUP  : Attribute, AppletData 対応版
//# 02000番台: 動画特化
//  -> 動画読込セッション
//# 60000 番台: セッション作成
// 60002: OpenAccessorSession                       a   for Ocean               4.0.0 NUP
// -------------------------------------------------Port----Client--------------Version------------------------
//# 02000番台: 動画読込セッション
// 02001: OpenAlbumMovieReadStream                  a/c for grc/Ocean           4.0.0 NUP
// 02002: CloseAlbumMovieReadStream                 a/c for grc/Ocean           4.0.0 NUP
// 02003: GetAlbumMovieReadStreamDataSize           a/c for grc/Ocean           4.0.0 NUP
// 02004: ReadDataFromAlbumMovieReadStream          a/c for grc/Ocean           4.0.0 NUP
// 02005: GetAlbumMovieReadStreamBrokenReason       a/c for grc/Ocean           4.0.0 NUP
// 02006: GetAlbumMovieReadStreamImageDataSize      a/c for grc/Ocean           4.0.0 NUP
// 02007: ReadImageDataFromAlbumMovieReadStream     a/c for grc/Ocean           4.0.0 NUP
// 02008: ReadFileAttributeFromAlbumMovieReadStream a/c for grc                 4.0.0 NUP
// -------------------------------------------------Port----Client--------------Version------------------------
//# 02400番台: 動画書込セッション
// 02401: OpenAlbumMovieWriteStream                 c   for grc                 internal
// 02402: FinishAlbumMovieWriteStream               c   for grc                 internal
// 02403: CommitAlbumMovieWriteStream               c   for grc                 internal
// 02404: DiscardAlbumMovieWriteStream              c   for grc                 internal
// 02405: DiscardAlbumMovieWriteStreamNoDelete      c   for grc                 internal
// 02411: StartAlbumMovieWriteStreamDataSection     c   for grc                 internal
// 02412: EndAlbumMovieWriteStreamDataSection       c   for grc                 internal
// 02413: StartAlbumMovieWriteStreamMetaSection     c   for grc                 internal
// 02414: EndAlbumMovieWriteStreamMetaSection       c   for grc                 internal
// 02421: ReadDataFromMovieWriteStream              c   for grc                 internal
// 02422: WriteDataToMovieWriteStream               c   for grc                 internal
// 02423: //ReadMetaToMovieWriteStream
// 02424: WriteMetaToMovieWriteStream               c   for grc                 internal
// 02431: GetMovieWriteStreamBrokenReason           c   for grc                 internal
// 02432: //SetMovieWriteStreamBrokenReason
// 02433: GetMovieWriteStreamDataSize               c   for grc                 internal
// 02434: SetMovieWriteStreamDataSize               c   for grc                 internal
// -------------------------------------------------Port----Client--------------Version------------------------
//# 03000番台: Jpegデコーダ
// 03001: DecodeJpeg                                c   for capsrv              internal
// -------------------------------------------------Port----Client--------------Version------------------------
//# 08000番台: テスト用
// 08001: ForceAlbumUnmounted                       a   for test                Preinstall
// 08002: ResetAlbumMountStatus                     a   for test                Preinstall
// 08011: RefreshAlbumCache                         a   for test                Preinstall
// 08012: GetAlbumCache                             a   for test                Preinstall（非サポート）
// 08012: GetAlbumCacheEx                           a   for test                4.0.0 NUP
// 08021: GetAlbumEntryFromApplicationAlbumEntryAruid a for test & 開発用機能   2.0.0 NUP（TODO: 3.0NUP までの暫定）
// 10011: SetInternalErrorConversionEnabled         a   for test                Preinstall
// -------------------------------------------------Port----Client--------------Version------------------------


namespace nn.capsrv.sf
{

    #region セッション（継承元）

    public interface IMovieReadStreamServiceObject : IServiceObject
    {
        [MethodId(2001)]
        Result OpenAlbumMovieReadStream(
            Out<detail.AlbumMovieReadStreamHandleType> outHandle,
            AlbumFileId fileId
        );

        [MethodId(2002)]
        Result CloseAlbumMovieReadStream(
            detail.AlbumMovieReadStreamHandleType handle
        );

        [MethodId(2003)]
        Result GetAlbumMovieReadStreamMovieDataSize(
            Out<int64_t> outSize,
            detail.AlbumMovieReadStreamHandleType handle
        );

        [MethodId(2004)]
        Result ReadMovieDataFromAlbumMovieReadStream(
            Out<int64_t> outReadSize,
            OutBuffer outBuffer,
            detail.AlbumMovieReadStreamHandleType handle,
            int64_t offset
        );

        [MethodId(2005)]
        Result GetAlbumMovieReadStreamBrokenReason(
            detail.AlbumMovieReadStreamHandleType handle
        );

        [MethodId(2006)]
        Result GetAlbumMovieReadStreamImageDataSize(
            Out<int64_t> outSize,
            detail.AlbumMovieReadStreamHandleType handle
        );

        [MethodId(2007)]
        Result ReadImageDataFromAlbumMovieReadStream(
            Out<int64_t> outReadSize,
            OutBuffer outBuffer,
            detail.AlbumMovieReadStreamHandleType handle,
            int64_t offset
        );

        [MethodId(2008)]
        Result ReadFileAttributeFromAlbumMovieReadStream(
            Out<detail.ScreenShotAttributeEx0> outAttribute,
            detail.AlbumMovieReadStreamHandleType handle
        );
    }

    public interface IMovieWriteStreamServiceObject : IMovieReadStreamServiceObject
    {
        [MethodId(2401)]
        Result OpenAlbumMovieWriteStream(
            Out<detail.AlbumMovieWriteStreamHandleType> outHandle,
            AlbumFileId fileId
        );

        [MethodId(2402)]
        Result FinishAlbumMovieWriteStream(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2403)]
        Result CommitAlbumMovieWriteStream(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2404)]
        Result DiscardAlbumMovieWriteStream(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2405)]
        Result DiscardAlbumMovieWriteStreamNoDelete(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2411)]
        Result StartAlbumMovieWriteStreamDataSection(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2412)]
        Result EndAlbumMovieWriteStreamDataSection(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2413)]
        Result StartAlbumMovieWriteStreamMetaSection(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2414)]
        Result EndAlbumMovieWriteStreamMetaSection(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2421)]
        Result ReadDataFromAlbumMovieWriteStream(
            Out<int64_t> outReadSize,
            OutBuffer outBuffer,
            detail.AlbumMovieWriteStreamHandleType handle,
            int64_t offset
        );

        [MethodId(2422)]
        Result WriteDataToAlbumMovieWriteStream(
            detail.AlbumMovieWriteStreamHandleType handle,
            int64_t offset,
            InBuffer inBuffer
        );

        //[MethodId(2423)]

        [MethodId(2424)]
        Result WriteMetaToAlbumMovieWriteStream(
            detail.AlbumMovieWriteStreamHandleType handle,
            InBuffer inBuffer,
            uint64_t makerNoteVersion,
            int64_t makerNoteOffset,
            int64_t makerNoteSize
        );

        [MethodId(2431)]
        Result GetAlbumMovieWriteStreamBrokenReason(
            detail.AlbumMovieWriteStreamHandleType handle
        );

        //[MethodId(2432)]

        [MethodId(2433)]
        Result GetAlbumMovieWriteStreamDataSize(
            Out<int64_t> outValue,
            detail.AlbumMovieWriteStreamHandleType handle
        );

        [MethodId(2434)]
        Result SetAlbumMovieWriteStreamDataSize(
            detail.AlbumMovieWriteStreamHandleType handle,
            int64_t value
        );

    }

    #endregion


    #region 撮影
    // caps:sc / am, ns 用
    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IScreenShotControlService : IServiceObject
    {
        // 画面の生画像を取得します（タイムアウトデフォルト版）
        [MethodId(1)]
        Result CaptureRawImageRgba32IntoArray(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.NonSecureMapTransfer()]
            OutBuffer pOutBuffer,
            int32_t layerStack,
            int64_t width,
            int64_t height,
            int64_t length,
            int64_t index
            );

        // 画面の生画像を取得します（タイムアウト指定版）
        [MethodId(2)]
        Result CaptureRawImageRgba32IntoArrayWithTimeout(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.NonSecureMapTransfer()]
            OutBuffer pOutBuffer,
            int32_t layerStack,
            int64_t width,
            int64_t height,
            int64_t length,
            int64_t index,
            TimeSpan timeout
            );

        // 共有バッファをキャプチャに設定します。
        [MethodId(3)]
        Result AttachSharedBufferToCaptureModule(
            nn.vi.fbshare.SharedBufferHandle hBuffer
            );

        //[MethodId(4)]
        //Result DetachSharedBufferToCaptureModule();

        // 共有バッファにキャプチャを実行します。
        [MethodId(5)]
        Result CaptureRawImageToAttachedSharedBuffer(
            int32_t dstIndex,
            int32_t layerStack,
            TimeSpan timeout
            );

        // 自分の画面写真として画像を保存する、UserIdList 付き
        [MethodId(210)]
        Result SaveScreenShotEx2ViaAm(
            Out<ApplicationAlbumEntry> outEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            capsrv.detail.ScreenShotAttributeEx0 attribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            UserIdList userIdList,
            nn.applet.AppletResourceUserId aruid,
            OverlayNotificationRequestType overlayRequest
            );

        // 画面写真の撮影を要求します。
        //[MethodId(1001)] Result RequestTakingScreenShot           (nn.ncm.ProgramId programId, nn.applet.AppletResourceUserId aruid);
        //[MethodId(1002)] Result RequestTakingScreenShotWithTimeout(nn.ncm.ProgramId programId, nn.applet.AppletResourceUserId aruid, TimeSpan timeout);
        //[MethodId(1003)] Result RequestTakingScreenShotEx0(nn.ncm.ProgramId programId, nn.applet.AppletResourceUserId aruid, TimeSpan timeout, detail.ScreenShotAttributeEx0 attribute);
        [MethodId(1004)] Result RequestTakingScreenShotEx1(
            uint64_t seqNo,
            nn.ncm.ProgramId programId,
            nn.applet.AppletResourceUserId aruid,
            TimeSpan timeout,
            detail.ScreenShotAttributeEx0 attribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            UserIdList userIdList
        );

        // 指定した seqNo 以下のキャプチャ要求をキャンセルします。
        [MethodId(1009)] Result CancelTakingScreenShot(uint64_t seqNo, ResultArgument reason);

        // テスト用。強制的にキャンセル状態を変更します。
        [MethodId(1010)] Result SetTakingScreenShotCancelState(uint64_t seqNo, ResultArgument reason);

        // アプリケーションによって画面写真の撮影が拒否されたことを通知します
        [MethodId(1011)]
        Result NotifyTakingScreenShotRefused(nn.ncm.ProgramId programId);

        // RequestTakingScreenShot() 以前の段階で画面写真の撮影に失敗したことを通知します
        [MethodId(1012)]
        Result NotifyTakingScreenShotFailed(nn.ncm.ProgramId programId);

        // 画面の生画像をストリーミング読み込みのために開きます
        [MethodId(1201)]
        Result OpenRawScreenShotReadStream(
            Out<int64_t> outSize,
            Out<int64_t> outWidth,
            Out<int64_t> outHeight,
            int32_t layerStack,
            TimeSpan timeout
            );

        // オーバーレイ用の動画サムネイルを設定します。
        // imageY, imageUv は入力だが、 OutBuffer。
        [MethodId(1101)]
        Result SetupOverlayMovieThumbnail(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer imageY,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer imageUv,
            int64_t width,
            int64_t height,
            AlbumFileId fileId
            );

        // 動画のメタデータを作成します（初期型）
        //[MethodId(1102)]
        //Result CreateProtoMovieMetaDataNv12(...);
        //[MethodId(1103)]
        //Result CreateProtoMovieMetaDataNv12Ex0(...);
        //[MethodId(1104)]
        //Result CreateProtoMovieMetaDataRgba(...);
        //[MethodId(1105)]
        //Result CreateProtoMovieMetaDataNv12Ex1(...);

        // 動画のメタデータを作成します
        [MethodId(1106)]
        Result CreateProtoMovieMetaDataNv12Ex2(
            Out<uint64_t> outSize,
            Out<int64_t> outMakerNoteOffset,
            Out<int64_t> outMakerNoteSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer outMeta,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer imageY,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer imageUv,
            int64_t width,
            int64_t height,
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            capsrv.detail.ScreenShotAttributeEx0 attribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            AppletData appletData,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            ApplicationData applicationData
            );

        // 動画のメタデータを作成します
        [MethodId(1107)]
        Result CreateProtoMovieMetaDataRgbaEx2(
            Out<uint64_t> outSize,
            Out<int64_t> outMakerNoteOffset,
            Out<int64_t> outMakerNoteSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer outMeta,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageRgba,
            int64_t width,
            int64_t height,
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            capsrv.detail.ScreenShotAttributeEx0 attribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            AppletData appletData,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            ApplicationData applicationData
            );

        // 生画像ストリームを閉じます
        [MethodId(1202)]
        Result CloseRawScreenShotReadStream();

        // 生画像ストリームから指定した範囲のデータを読みます
        [MethodId(1203)]
        Result ReadRawScreenShotReadStream(
            Out<int64_t> outReadSize,
            OutBuffer outBuffer,
            int64_t offset
            );

    }

    // caps:ss / applet 用
    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IScreenShotService : IServiceObject
    {
        // 自分の画面写真として画像を保存する
        [MethodId(201)]
        Result SaveScreenShot(
            Out<ApplicationAlbumEntry> outEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            ScreenShotSizeType size,
            nn.applet.CheckedAppletResourceUserId aruid,
            OverlayNotificationRequestType overlayRequest
            );

        // 編集した画面写真として画像を保存する
        [MethodId(202)]
        Result SaveEditedScreenShot(
            Out<AlbumEntry> outFileEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer thumbnailBuffer,
            int64_t imageWidth,
            int64_t imageHeight,
            int64_t thumbnailWidth,
            int64_t thumbnailHeight,
            AlbumFileId originalFileId
            );

        [MethodId(203)]
        Result SaveScreenShotEx0(
            Out<ApplicationAlbumEntry> outEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            detail.ScreenShotAttributeEx0 attribute,
            nn.applet.CheckedAppletResourceUserId aruid,
            OverlayNotificationRequestType overlayRequest
            );

        // 編集した画面写真として画像を保存する
        [MethodId(204)]
        Result SaveEditedScreenShotEx0(
            Out<AlbumEntry> outFileEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer thumbnailBuffer,
            int64_t imageWidth,
            int64_t imageHeight,
            int64_t thumbnailWidth,
            int64_t thumbnailHeight,
            detail.ScreenShotAttributeEx0 attribute,
            AlbumFileId originalFileId
            );

        // 編集した画面写真として画像を保存する
        [MethodId(206)]
        Result SaveEditedScreenShotEx1(
            Out<AlbumEntry> outFileEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer thumbnailBuffer,
            int64_t imageWidth,
            int64_t imageHeight,
            int64_t thumbnailWidth,
            int64_t thumbnailHeight,
            detail.ScreenShotAttributeEx0 attribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            AppletData appletData,
            AlbumFileId originalFileId
            );

        // 動画ファイルから切り出して画面写真として画像を保存する。
        // 基本、SaveEditedScreenShotEx1() の HIPC と同機能だが、
        // 動画ファイルの ScreenShotAttributeEx0 から情報を引き継ぐようにする。
        // また、引継ぎ方法を分離できるように、別 IPC として定義しておく。
        [MethodId(208)]
        Result SaveScreenShotOfMovieEx1(
            Out<AlbumEntry> outFileEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer thumbnailBuffer,
            int64_t imageWidth,
            int64_t imageHeight,
            int64_t thumbnailWidth,
            int64_t thumbnailHeight,
            detail.ScreenShotAttributeEx0 attribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            AppletData appletData,
            AlbumFileId originalFileId
            );
    }

    // caps:su / application 用
    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IScreenShotApplicationService : IServiceObject
    {
        // 自分の画面写真として画像を保存する
        [MethodId(201)]
        Result SaveScreenShot(
            Out<ApplicationAlbumEntry> outEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            ScreenShotSizeType size,
            nn.applet.CheckedAppletResourceUserId aruid,
            OverlayNotificationRequestType overlayRequest
            );

        // 自分の画面写真として画像を保存する
        [MethodId(203)]
        Result SaveScreenShotEx0(
            Out<ApplicationAlbumEntry> outEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            detail.ScreenShotAttributeEx0 attribute,
            nn.applet.CheckedAppletResourceUserId aruid,
            OverlayNotificationRequestType overlayRequest
            );

        // アプリから UserIdList 情報付きでアルバム画像を保存する
        [MethodId(210)]
        Result SaveScreenShotEx2(
            Out<ApplicationAlbumEntry> outEntry,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer imageBuffer,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            capsrv.detail.ScreenShotAttributeEx0 attribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            UserIdList userIdList,
            nn.applet.AppletResourceUserId aruid,
            OverlayNotificationRequestType overlayRequest
            );
    }
#endregion

#region アルバム
    // caps:c
    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IAlbumControlService : IServiceObject
    {
        // ストレージが利用可能になったことを通知します
        [MethodId(2001)]
        Result NotifyAlbumStorageIsAvailable(AlbumStorageType storage);

        // ストレージが利用不可になったことを通知します
        [MethodId(2002)]
        Result NotifyAlbumStorageIsUnavailable(AlbumStorageType storage);

        // 起動中のアプリケーションの情報を登録します
        [MethodId(2011)]
        Result RegisterAppletResourceUserId(nn.applet.AppletResourceUserId aruid, nn.ncm.ApplicationId applicationId);

        // 起動中のアプリケーションの情報を削除します
        [MethodId(2012)]
        Result UnregisterAppletResourceUserId(nn.applet.AppletResourceUserId aruid, nn.ncm.ApplicationId applicationId);

        // 指定した auid を持つアプリケーションのアプリケーション ID を取得します
        [MethodId(2013)]
        Result GetApplicationIdFromAruid(Out<nn.ncm.ApplicationId> outApplicationId, nn.applet.AppletResourceUserId aruid);

        // 指定したアプリケーション ID が登録されているかを取得します。
        [MethodId(2014)]
        Result CheckApplicationIdRegistered(nn.ncm.ApplicationId applicationId);

        // 現在のアルバムファイル ID を取得します
        [MethodId(2101)]
        Result GenerateCurrentAlbumFileId(Out<AlbumFileId> outFileId, nn.ncm.ProgramId programId, AlbumFileContentsType contentType);

        // アプリケーション向けの AlbumEntry を取得します。
        [MethodId(2102)]
        Result GenerateApplicationAlbumEnrty(Out<ApplicationAlbumEntry> outEntry, AlbumEntry srcEntry, nn.ncm.ApplicationId applicationId);

        //// 画面写真ファイルをアルバムに保存します
        //[MethodId(2201)]
        //Result SaveAlbumScreenShotFile(
        //    AlbumFileId fileId,
        //    [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
        //    [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
        //    nn.sf.InBuffer fileData
        //);

        // 画面写真ファイルをアルバムに保存します
        [MethodId(2202)]
        Result SaveAlbumScreenShotFileEx(
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer fileData,
            uint64_t makerNoteVersion,
            int64_t makerNoteOffset,
            int64_t makerNoteSize
        );

        // オーバーレイ用のサムネイルデータを設定します（静止画）
        [MethodId(2301)]
        Result SetOverlayScreenShotThumbnailData(
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer thumbData
        );

        // オーバーレイ用のサムネイルデータを設定します（動画）
        [MethodId(2302)]
        Result SetOverlayMovieThumbnailData(
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.InBuffer thumbData
        );

        // セッションを作成します
        [MethodId(60001)]
        Result OpenControlSession(
            Out<IAlbumControlSession> outValue,
            applet.CheckedAppletResourceUserId aruid
        );
    }

    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IAlbumControlSession
        : IMovieWriteStreamServiceObject
    {
    }


    // ファイルアクセス関数
    // caps:a
    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IAlbumAccessorService : IServiceObject
    {

        [MethodId(0)]
        Result GetAlbumFileCount(
            Out<uint64_t> outCount,
            AlbumStorageType storage
            );

        [MethodId(1)]
        Result GetAlbumFileList(
            Out<uint64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutArray<AlbumEntry> pOutList,
            AlbumStorageType storage
            );

        [MethodId(2)]
        Result LoadAlbumFile(
            Out<uint64_t> outSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId
            );

        [MethodId(3)]
        Result DeleteAlbumFile(
            AlbumFileId fileId
            );

        [MethodId(4)]
        Result StorageCopyAlbumFile(
            AlbumFileId sourceFileId,
            AlbumStorageType destinationStorage
            );

        [MethodId(5)]
        Result IsAlbumMounted(
            Out<bool> outValue,
            AlbumStorageType storage
            );

        [MethodId(6)]
        Result GetAlbumUsage(
            Out<detail.AlbumUsage2> outValue,
            AlbumStorageType storage
            );

        [MethodId(7)]
        Result GetAlbumFileSize(
            Out<uint64_t> outSize,
            AlbumFileId fileId
            );

        [MethodId(8)]
        Result LoadAlbumFileThumbnail(
         Out<uint64_t> outSize,
         [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer outBuffer,
         AlbumFileId fileId
         );

        [MethodId(9)]
        Result LoadAlbumScreenShotImage(
            Out<uint64_t> outWidth,
            Out<uint64_t> outHeight,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        [MethodId(10)]
        Result LoadAlbumScreenShotThumbnailImage(
            Out<uint64_t> outWidth,
            Out<uint64_t> outHeight,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        [MethodId(11)]
        Result GetAlbumEntryFromApplicationAlbumEntry(
            Out<AlbumEntry> outEntry,
            ApplicationAlbumEntry srcEntry,
            nn.ncm.ApplicationId applicationId
            );

        [MethodId(12)]
        Result LoadAlbumScreenShotImageEx(
            Out<uint64_t> outWidth,
            Out<uint64_t> outHeight,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        [MethodId(13)]
        Result LoadAlbumScreenShotThumbnailImageEx(
            Out<uint64_t> outWidth,
            Out<uint64_t> outHeight,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        [MethodId(14)]
        Result LoadAlbumScreenShotImageEx0(
            Out<uint64_t> outWidth,
            Out<uint64_t> outHeight,
            Out<detail.ScreenShotAttributeEx0> outAttribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        [MethodId(15)]
        Result GetAlbumUsage3(
            Out<detail.AlbumUsage3> outValue,
            AlbumStorageType storage
            );

        [MethodId(16)]
        Result GetAlbumMountResult(
            AlbumStorageType storage
            );

        [MethodId(17)]
        Result GetAlbumUsage16(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            Out<detail.AlbumUsage16> outValue,
            AlbumStorageType storage,
            AlbumFileContentsFlag contentsMask
            );

        [MethodId(100)]
        Result GetAlbumFileCountEx0(
            Out<uint64_t> outCount,
            AlbumStorageType storage,
            AlbumFileContentsFlag contentsMask
            );

        [MethodId(101)]
        Result GetAlbumFileListEx0(
            Out<uint64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutArray<AlbumEntry> pOutList,
            AlbumStorageType storage,
            AlbumFileContentsFlag contentsMask
            );

        [MethodId(301)]
        Result GetLastOverlayScreenShotThumbnail(
            Out<AlbumFileId> outFileId,
            Out<uint64_t> outSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer outBuffer
            );

        [MethodId(302)]
        Result GetLastOverlayMovieThumbnail(
            Out<AlbumFileId> outFileId,
            Out<uint64_t> outSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer outBuffer
            );

        [MethodId(401)]
        Result GetAutoSavingStorage(Out<AlbumStorageType> outValue);

        [MethodId(501)]
        Result GetRequiredStorageSpaceSizeToCopyAll(Out<uint64_t> outSize, AlbumStorageType dstStorage, AlbumStorageType srcStorage);

        [MethodId(1001)]
        Result LoadAlbumScreenShotThumbnailImageEx0(
            Out<uint64_t> outWidth,
            Out<uint64_t> outHeight,
            Out<detail.ScreenShotAttributeEx0> outAttribute,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        [MethodId(1002)]
        Result LoadAlbumScreenShotImageEx1(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            Out<sf.LoadAlbumScreenShotImageOutputEx1> output,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        [MethodId(1003)]
        Result LoadAlbumScreenShotThumbnailImageEx1(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            Out<sf.LoadAlbumScreenShotImageOutputEx1> output,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        // DevMenuCommandSystem 用
        [MethodId(50000)]
        Result LoadMakerNoteInfoForDebug(
            Out<uint64_t> outFileSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer outBuffer,
            AlbumFileId fileId,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer
            );

        // セッションを作成します
        [MethodId(60002)]
        Result OpenAccessorSession(
            Out<IAlbumAccessorSession> outValue,
            applet.CheckedAppletResourceUserId aruid
        );

        //--------------------------------
        // テスト用 API
        //--------------------------------

        // 指定したストレージをアンマウントします（テスト用）
        [MethodId(8001)]
        Result ForceAlbumUnmounted(
            AlbumStorageType storage
            );

        // 指定したストレージのマウント状態をリセットします（テスト用）
        [MethodId(8002)]
        Result ResetAlbumMountStatus(
            AlbumStorageType storage
            );

        // アルバムのキャッシュを作り直します（テスト用）
        [MethodId(8011)]
        Result RefreshAlbumCache(
            AlbumStorageType storage
            );

        // アルバムのキャッシュを取得します（テスト用。非サポート）
        [MethodId(8012)]
        Result GetAlbumCache(
            Out<AlbumCacheData> outValue,
            AlbumStorageType storage
            );

        // アルバムのキャッシュを取得します（テスト用）
        [MethodId(8013)]
        Result GetAlbumCacheEx(
            Out<AlbumCacheData> outValue,
            AlbumStorageType storage,
            AlbumFileContentsType contents
            );

        // ApplicationAlbumEntry と自分の Aruid から AlbumEntry を取得します（開発用）
        [MethodId(8021)]
        Result GetAlbumEntryFromApplicationAlbumEntryAruid(
            Out<AlbumEntry> outEntry,
            ApplicationAlbumEntry srcEntry,
            nn.applet.CheckedAppletResourceUserId aruid
            );


        // 内部 Result 値の変換の有効・無効を変更します（テスト用）
        [MethodId(10011)]
        Result SetInternalErrorConversionEnabled(
            bool value
            );

    }

    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IAlbumAccessorSession
        : IMovieReadStreamServiceObject
    {
    }


    // アプリ向けのアルバムファイルアクセス関数
    // caps:u
    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IAlbumApplicationService : IServiceObject
    {
        // deprecated 扱い。互換性のために残しておく
        [MethodId(102)]
        Result GetAlbumFileListByAruid(
            Out<uint64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutArray<ApplicationAlbumFileEntry> pOutList,
            AlbumFileContentsType contents,
            int64_t beginPosixTime,
            int64_t endPosixTime,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        // 上記 GetAlbumFileListByAruid() の修正版
        [MethodId(140)]
        Result GetAlbumFileListEx0ByAruid(
            Out<uint64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutArray<ApplicationAlbumFileEntry> pOutList,
            AlbumFileContentsType contents,
            AlbumFileDateTime beginDateTime,
            AlbumFileDateTime endDateTime,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        // 上記 GetAlbumFileListEx0ByAruid() のユーザ識別子あり版
        [MethodId(141)]
        Result GetAlbumFileListEx1ByAruid(
            Out<uint64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutArray<ApplicationAlbumFileEntry> pOutList,
            AlbumFileContentsType contents,
            nn.account.Uid uid,
            AlbumFileDateTime beginDateTime,
            AlbumFileDateTime endDateTime,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(103)]
        Result DeleteAlbumFileByAruid(
            ApplicationAlbumFileEntry entry,
            AlbumFileContentsType contents,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(104)]
        Result GetAlbumFileSizeByAruid(
            Out<uint64_t> outSize,
            ApplicationAlbumFileEntry entry,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(105)]
        Result DeleteAlbumFileByAruidForDebug(
            ApplicationAlbumFileEntry entry,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(110)]
        Result LoadAlbumScreenShotImageByAruid(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            Out<sf.LoadAlbumScreenShotImageOutputForApplication> output,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            ApplicationAlbumFileEntry entry,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(120)]
        Result LoadAlbumScreenShotThumbnailImageByAruid(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            Out<sf.LoadAlbumScreenShotImageOutputForApplication> output,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outBuffer,
            ApplicationAlbumFileEntry entry,
            nn.capsrv.ScreenShotDecodeOption option,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer workBuffer,
            nn.applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(130)]
        Result PrecheckToCreateContentsByAruid(AlbumFileContentsType contents, uint64_t size, nn.applet.CheckedAppletResourceUserId aruid);

        // セッションを作成
        [MethodId(60002)]
        Result OpenAccessorSessionForApplication(
            Out<IAlbumAccessorApplicationSession> outValue,
            ApplicationAlbumFileEntry entry,
            applet.CheckedAppletResourceUserId aruid
        );

    }

    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IAlbumAccessorApplicationSession : IServiceObject
    {
        [MethodId(2001)]
        Result OpenAlbumMovieReadStream(
            Out<detail.AlbumMovieReadStreamHandleType> outHandle,
            ApplicationAlbumFileEntry entry,
            nn.applet.CheckedAppletResourceUserId aruid
        );

        [MethodId(2002)]
        Result CloseAlbumMovieReadStream(
            detail.AlbumMovieReadStreamHandleType handle
        );

        [MethodId(2003)]
        Result GetAlbumMovieReadStreamMovieDataSize(
            Out<int64_t> outSize,
            detail.AlbumMovieReadStreamHandleType handle
        );

        [MethodId(2004)]
        Result ReadMovieDataFromAlbumMovieReadStream(
            Out<int64_t> outReadSize,
            OutBuffer outBuffer,
            detail.AlbumMovieReadStreamHandleType handle,
            int64_t offset
        );

        [MethodId(2005)]
        Result GetAlbumMovieReadStreamBrokenReason(
            detail.AlbumMovieReadStreamHandleType handle
        );
    }

#endregion

#region JPEG デコーダ
    // caps:dc
    [CppRefPath("<nn/capsrv/sf/capsrv_Services.sfdl.h>")]
    public interface IDecoderControlService : IServiceObject
    {
        [MethodId(3001)]
        Result DecodeJpeg(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.MapTransferSecurity(Nintendo.ServiceFramework.Hipc.MapTransferSecurity.NonSecure)]
            nn.sf.OutBuffer outImageBuf,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.InBuffer inJpegBuf,
            uint32_t width,
            uint32_t height,
            nn.capsrv.ScreenShotDecodeOption option
            );
    }
#endregion


}
