﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>

#include "../screenshot/visrv_CaptureModuleSharedTexture.h"

namespace nn{ namespace capsrv{ namespace server{

    // スレッド安全にすること。
    class TransitionCaptureModule
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result AttachSharedMemoryPool(const nn::capsrv::capture::MemoryPoolImportData& poolInfo, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
        nn::Result CaptureDisplayToSharedTexture(int destTextureIndex, nn::vi::LayerStack srcLayerStack, nn::TimeSpan timeout) NN_NOEXCEPT;

    private:
        nn::os::SdkMutexType m_Mutex;
        screenshot::CaptureModuleSharedTexture m_CaptureModuleSharedTexture;

    };

}}}
