﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "../capsrvServer_EnvironmentInfo.h"
#include "../detail/visrv_OverlayNotifier.h"
#include "../screenshot/visrv_ScreenShotSequenceManager.h"
#include "visrv_ScreenShotWorkMemory.h"
#include "visrv_ScreenShotErrorConverter.h"
#include "visrv_ScreenShotCaptureModule.h"
#include "visrv_TransitionCaptureModule.h"
#include "visrv_ScreenShotContextManager.h"

#include "visrv_ScreenShotControlServerManager.h"
#include "visrv_ScreenShotServerManager.h"
#include "visrv_ScreenShotRequestQueue.h"
#include "visrv_ScreenShotWorker.h"

namespace nn{ namespace capsrv{ namespace server{

    extern EnvironmentInfo                g_ScreenShotEnvironmentInfo;
    extern ScreenShotWorkMemory           g_ScreenShotWorkMemory;

    extern OverlayNotifier                g_OverlayNotifier;
    extern ScreenShotCaptureModule        g_ScreenShotCaptureModule;
    extern TransitionCaptureModule        g_TransitionCaptureModule;
    extern ScreenShotErrorConverter       g_ScreenShotErrorConverter;
    extern ScreenShotContextManager       g_ScreenShotContextManager;
    extern screenshot::ScreenShotSequenceManager g_ScreenShotSequenceManager;

    extern ScreenShotControlServerManager g_ScreenShotControlServerManager;
    extern ScreenShotServerManager        g_ScreenShotServerManager;
    extern ScreenShotControlRequestQueue  g_ScreenShotControlRequestQueue;
    extern ScreenShotRequestQueue         g_ScreenShotRequestQueue;
    extern ScreenShotWorker               g_ScreenShotWorker;

}}}
