﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ScreenShotContextMacro.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    nn::Result AcquireScreenShotContextImpl(ScreenShotContext** pOutContext) NN_NOEXCEPT
    {
        // 先に Recovery を実行
        NN_RESULT_THROW_UNLESS(g_ScreenShotContextManager.TryRecoveryAll(), ResultScreenShotCaptureFailed());
        // 単に Suspend しているものが居たらエラー
        NN_RESULT_THROW_UNLESS(!g_ScreenShotContextManager.HasSuspendedContext(), ResultScreenShotCaptureFailed());
        *pOutContext = g_ScreenShotContextManager.AcquireContext();
        NN_RESULT_SUCCESS;
    }

    nn::Result ResumeScreenShotContextImpl(ScreenShotContext** pOutContext, ScreenShotContextSuspendedTask task) NN_NOEXCEPT
    {
        // 先に Recovery を実行
        NN_RESULT_THROW_UNLESS(g_ScreenShotContextManager.TryRecoveryAll(), ResultScreenShotCaptureFailed());
        // Suspend しているものが居なければエラー
        NN_RESULT_THROW_UNLESS(g_ScreenShotContextManager.HasSuspendedContext(task), ResultScreenShotCaptureFailed());
        *pOutContext = g_ScreenShotContextManager.ResumeContext(task);
        NN_RESULT_SUCCESS;
    }

    void ReleaseScreenShotContextImpl(ScreenShotContext* pContext) NN_NOEXCEPT
    {
        if(pContext->IsRecoveryRequired() || pContext->IsSuspendRequired())
        {
            g_ScreenShotContextManager.SuspendContext(pContext);
        }
        else
        {
            g_ScreenShotContextManager.ReleaseContext(pContext);
        }
    }

}}}}
