﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ScreenShotSequenceManager.h"

#include <mutex>
#include <algorithm>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    typedef nn::capsrv::ResultInternalScreenShotCanceledAsNoTarget DefaultReason;

    void ScreenShotSequenceManager::Initialize() NN_NOEXCEPT
    {
        m_Mutex.Initialize();
        m_CanceledSequenceNumber = 0;
        m_CancelReason = DefaultReason();

    }

    void ScreenShotSequenceManager::Finalize() NN_NOEXCEPT
    {
    }

    void ScreenShotSequenceManager::RequestCancelSequence(uint64_t seqNo, nn::Result reason) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(reason.IsFailure());

        std::lock_guard<decltype(m_Mutex)> lock(m_Mutex);

        if(m_CanceledSequenceNumber <= seqNo)
        {
            m_CanceledSequenceNumber = seqNo;
            if(reason.IsFailure())
            {
                m_CancelReason = reason;
            }
            else
            {
                m_CancelReason = DefaultReason();
            }
        }
    }

    void ScreenShotSequenceManager::SetCancelState(uint64_t seqNo, nn::Result reason) NN_NOEXCEPT
    {
        std::lock_guard<decltype(m_Mutex)> lock(m_Mutex);

        m_CanceledSequenceNumber = seqNo;

        if(reason.IsFailure())
        {
            m_CancelReason = reason;
        }
        else
        {
            m_CancelReason = DefaultReason();
        }
    }

    void ScreenShotSequenceManager::GetCanceledSequenceNumber(uint64_t* pOutSeqNo, nn::Result* pOutReason) NN_NOEXCEPT
    {
        std::lock_guard<decltype(m_Mutex)> lock(m_Mutex);

        *pOutSeqNo = m_CanceledSequenceNumber;
        *pOutReason = m_CancelReason;
    }
}}}}
