﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_CreateProtoMovieMetaDataNv12.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "../capsrvServer_Config.h"
#include "action/visrv_DownsampleForViewerThumbnailFromImageBufferNv12.h"
#include "action/visrv_EncodeViewerThumbnailJpeg.h"
#include "action/visrv_CreateExifBuilder.h"
#include "action/visrv_EncodeScreenShotJpegNv12.h"
#include "action/visrv_CalculateMakerNoteRange.h"
#if defined(NN_CAPSRV_DEBUG_SAVE_MOVIE_META_DATA_AS_SCREENSHOT)
#include "action/visrv_SaveScreenShotFile.h"
#endif

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    nn::Result CreateProtoMovieMetaDataNv12(ScreenShotContext& context) NN_NOEXCEPT
    {
        // PhotoViewer 用サムネイルを作成
        NN_RESULT_DO(action::DownsampleForViewerThumbnailFromImageBufferNv12(context));
        NN_RESULT_DO(action::EncodeViewerThumbnailJpeg(context));

        // Jpeg データ作成
        {
            NN_RESULT_DO(action::CreateExifBuilder(context));
            NN_UTIL_SCOPE_EXIT{ action::DestroyExifBuilder(context); }; // エンコードしたら破棄する

            NN_RESULT_DO(action::EncodeScreenShotJpegNv12(context));
        }

        NN_RESULT_DO(action::CalculateMakerNoteRange(context));

#if defined(NN_CAPSRV_DEBUG_SAVE_MOVIE_META_DATA_AS_SCREENSHOT)
        {
            NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
            NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_INOUT(context, AlbumFileId);

            NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileId, context, AlbumFileId);
            fileId.contents = nn::capsrv::AlbumFileContents_ScreenShot;
            NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, AlbumFileId, fileId);

            NN_RESULT_DO(action::SaveScreenShotFile(context));
        }
#endif

        NN_RESULT_SUCCESS;
    }

}}}}
