﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_AlbumControl.h>
#include <nn/capsrv/capsrv_ThumbnailFormat.h>

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // Overlay 用サムネイルを登録する（静止画）
    static nn::Result SetOverlayScreenShotThumbnail(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, OverlayAlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, AlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawOverlayThumbnailMemory, ThumbnailImageDataSize_Default);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("set thumb ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileId, context, AlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(data, size, context, RawOverlayThumbnailMemory);

        NN_RESULT_DO(nn::capsrv::SetOverlayScreenShotThumbnailData(fileId, data, size));

        NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, OverlayAlbumFileId, fileId);
        NN_RESULT_SUCCESS;
    }

}}}}}
