﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_AlbumControl.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // Aruid から ApplicationId を取得する
    // @param[in]  context.Aruid
    // @param[out] context.ApplicationId
    static nn::Result GetApplicationIdFromAruid(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, Aruid);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, ApplicationId);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("appId     ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(aruid, context, Aruid);
        nn::ncm::ApplicationId applicationId = {};
        NN_RESULT_DO(nn::capsrv::GetApplicationIdFromAruid(&applicationId, aruid));

        NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, ApplicationId, applicationId);
        NN_RESULT_SUCCESS;
    }

}}}}}
