﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>
#include "../capsrvServer_Config.h"
#include "../capsrvServer_ResultPrivate.h"

#ifdef NN_CAPSRV_USE_LIBJPEG_TURBO
#include "capsrvServer_SoftwareJpegEncoderType-encoder.libjpegTurbo.h"
#else
#include "capsrvServer_SoftwareJpegEncoderType-encoder.libjpeg.h"
#endif

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    class JpegDestinationMgrBase;

    namespace detail
    {
        class JpegDestinationMgrImpl
            : public JpegEncoderType::jpeg_destination_mgr
        {
        public:
            typedef JpegDestinationMgrImpl SelfType;
            typedef JpegEncoderType::boolean boolean;
            typedef JpegEncoderType::jpeg_destination_mgr jpeg_destination_mgr;
            typedef JpegEncoderType::j_compress_ptr j_compress_ptr;
            typedef JpegEncoderType::JOCTET JOCTET;

        public:
            explicit JpegDestinationMgrImpl(JpegDestinationMgrBase* pBase) NN_NOEXCEPT;

            size_t GetWrittenSize() const NN_NOEXCEPT;

            static void OnOutOfMemory(j_compress_ptr cinfo) NN_NOEXCEPT;

        private:
            static void OnInitDestination(j_compress_ptr cinfo) NN_NOEXCEPT;
            static boolean OnEmptyOutputBuffer(j_compress_ptr cinfo) NN_NOEXCEPT;
            static void OnTermDestination(j_compress_ptr cinfo) NN_NOEXCEPT;

        private:
            JpegDestinationMgrBase* m_pBase;
            size_t m_TotalBufferSize;
            size_t m_TotalWrittenSize;
        };
    }

    class JpegDestinationMgrBase
    {
        NN_DISALLOW_COPY(JpegDestinationMgrBase);
        NN_DISALLOW_MOVE(JpegDestinationMgrBase);
    public:
        typedef JpegEncoderType::j_compress_ptr j_compress_ptr;
        typedef JpegEncoderType::jpeg_destination_mgr jpeg_destination_mgr;
    public:
        JpegDestinationMgrBase() NN_NOEXCEPT;

        JpegEncoderType::jpeg_destination_mgr* Get() NN_NOEXCEPT;

        // JPEG エンコードの開始時に呼ばれる。
        // デフォルトでは AbortByOutOfMemory を呼び出して終了する。
        virtual void Open(void** pOutBuffer, size_t* pOutBufferSize, j_compress_ptr cinfo) NN_NOEXCEPT;

        // JPEG エンコードの正常終了時に呼ばれる。
        // デフォルトでは何もしない。
        virtual void Close(j_compress_ptr cinfo) NN_NOEXCEPT;

        // JPEG エンコード中に出力バッファが不足した場合に呼ばれる。
        // デフォルトでは AbortByOutOfMemory を呼び出して終了する。
        virtual void GetNextBuffer(void** pOutNextBuffer, size_t* pOutNextBufferSize, j_compress_ptr cinfo) NN_NOEXCEPT;

        // 書き込んだ合計サイズを取得する。
        // エンコードの終了後に呼び出す。
        size_t GetWrittenSize() const NN_NOEXCEPT;

    protected:
        // メモリ不足によりエンコード処理を強制終了させる
        // Open/Close/GetNextBuffer の中で呼び出す。
        void AbortByOutOfMemory(j_compress_ptr cinfo) NN_NOEXCEPT;

    private:
        detail::JpegDestinationMgrImpl m_Impl;
    };

}}}}
