﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_ParseMakerNote.h"

#include <cstring>
#include <nn/util/util_Endian.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "capsrvServer_GenerateMakerNote.h"
#include "capsrvServer_EncryptMakerNote.h"

#include "capsrvServer_MakerNoteEntryParser.impl.h"
#include "capsrvServer_MakerNoteEntryDecoder.impl.h"
#include "capsrvServer_MakerNoteEntryVisitor.impl.h"
#include "capsrvServer_MakerNoteParser.impl.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    nn::Result TryParseMakerNote(
        MakerNoteInfo* pOutValue,
        const void* pMakerNoteData,
        size_t makerNoteDataSize
        ) NN_NOEXCEPT
    {
        return MakerNoteParser<MakerNoteInfo, MakerNoteTag>::Parse(pOutValue, pMakerNoteData, makerNoteDataSize);
    }

}}}}
