﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_GetApplicationAlbumEntry.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/crypto/crypto_AesEncryptor.h>
#include <nn/crypto/crypto_AesDecryptor.h>


namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    NN_STATIC_ASSERT(sizeof(ApplicationAlbumEntry) == sizeof(AlbumEntry));
    NN_STATIC_ASSERT(sizeof(ApplicationAlbumEntryKey) == sizeof(AlbumEntry));

    ApplicationAlbumEntry GetApplicationAlbumEntryFromAlbumEntry(const AlbumEntry& src, const ApplicationAlbumEntryKey& key) NN_NOEXCEPT
    {
        nn::crypto::AesEncryptor256 encryptor;

        NN_STATIC_ASSERT(2 * encryptor.BlockSize == sizeof(AlbumEntry));
        NN_STATIC_ASSERT(sizeof(key) == sizeof(src));

        ApplicationAlbumEntry value = {};
        const char* pInputBuffer = reinterpret_cast<const char*>(&src);
        char* pOutputBuffer = reinterpret_cast<char*>(&value);

        encryptor.Initialize(&key, sizeof(ApplicationAlbumEntryKey));

        encryptor.EncryptBlock(pOutputBuffer, encryptor.BlockSize, pInputBuffer, encryptor.BlockSize);
        pOutputBuffer += encryptor.BlockSize;
        pInputBuffer += encryptor.BlockSize;
        encryptor.EncryptBlock(pOutputBuffer, encryptor.BlockSize, pInputBuffer, encryptor.BlockSize);

        return value;
    }

    AlbumEntry GetAlbumEntryFromApplicationAlbumEntry(const ApplicationAlbumEntry& src, const ApplicationAlbumEntryKey& key) NN_NOEXCEPT
    {
        nn::crypto::AesDecryptor256 decryptor;

        NN_STATIC_ASSERT(2 * decryptor.BlockSize == sizeof(AlbumEntry));
        NN_STATIC_ASSERT(sizeof(key) == sizeof(src));

        AlbumEntry value = {};
        const char* pInputBuffer = reinterpret_cast<const char*>(&src);
        char* pOutputBuffer = reinterpret_cast<char*>(&value);

        decryptor.Initialize(&key, sizeof(ApplicationAlbumEntryKey));

        decryptor.DecryptBlock(pOutputBuffer, decryptor.BlockSize, pInputBuffer, decryptor.BlockSize);
        pOutputBuffer += decryptor.BlockSize;
        pInputBuffer += decryptor.BlockSize;
        decryptor.DecryptBlock(pOutputBuffer, decryptor.BlockSize, pInputBuffer, decryptor.BlockSize);

        return value;
    }

}}}}
