﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "capsrvServer_MakerNoteInfo.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    // @brief MakerNote を生成します。
    // @param[out] pBuffer 生成した MakerNote を書き込むバッファ
    // @param[in] bufferSize pBuffer の大きさ（バイト）
    // @param[in] info 書き込む MakerNoteInfo
    // @pre pBuffer != nullptr
    // @pre bufferSize >= MakerNoteSizeLimit
    // @return 書き込んだバイト数を返します。
    size_t GenerateMakerNote(void* pBuffer, size_t bufferSize, const MakerNoteInfo& info) NN_NOEXCEPT;

}}}}
