﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_GenerateMakerNote.h"

#include <cstring>

#include <nn/nn_SdkAssert.h>
#include <nn/util/util_Endian.h>

#include "capsrvServer_MakerNoteInfo.h"
#include "capsrvServer_MakerNoteGenerator.impl.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    size_t GenerateMakerNote(void* pBuffer, size_t bufferSize, const MakerNoteInfo& info) NN_NOEXCEPT
    {
        return MakerNoteGenerator<MakerNoteInfo, MakerNoteTag>::Generate(pBuffer, bufferSize, info);
    }

}}}}
